/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainCursor;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBHandle;
import com.mmmhis.domain.db.DBLHandle;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLHandle;
import com.mmmhis.domain.table.TBLStruct;
import com.mmmhis.domain.table.TBLTable;
import java.io.File;

public class TBLConvert {
    public static final int DSL_GATEWAY = 1;
    public static final int TdSTATUS_NORMAL = 0;
    public static final int Tbl_CONSOLID_ERR = 54;
    DBControl DbControl;
    DBHandle fd;
    DBLHandle dh;
    TBLTable proto_table;
    byte[] unmappedMapframe;
    DomainByteArrayFileMap mappedMapframe;
    int mapfIdx;
    TBLFile tblfile;
    TBLHandle tblhand;
    DomainCursor curse;

    public static int convertCtlToTbl(String inpath, File outFile) {
        boolean mptrIdx = false;
        TBLConvert cvt = new TBLConvert();
        int rc = cvt.OpenInputFile(inpath);
        if (rc != 0) {
            return rc;
        }
        rc = cvt.ReadProtos();
        if (rc != 0) {
            return rc;
        }
        rc = cvt.OpenOutputFile(outFile);
        if (rc != 0) {
            return rc;
        }
        DomainEcNumber mptr = cvt.mappedMapframe != null ? new DomainEcNumber(cvt.mappedMapframe, cvt.mapfIdx) : new DomainEcNumber(cvt.unmappedMapframe, cvt.mapfIdx);
        while (mptr.getOffset() < mptr.getLen() - 1) {
            DomainString section = mptr.getEcString();
            int fp = mptr.getEcNumber();
            int flags = mptr.getEcNumber();
            if ((flags & 1) == 0 || section.compareTo("_prototypes_%R") == 0) continue;
            cvt.dh.reset();
            rc = cvt.CvtTraverse(section);
            if (rc == 0) continue;
            return rc;
        }
        rc = cvt.CloseOutputFile();
        if (rc != 0) {
            return rc;
        }
        rc = cvt.CloseInputFile();
        cvt = null;
        return rc;
    }

    private int OpenInputFile(String inpath) throws DomainException {
        this.DbControl = this.DbOpenSimple(inpath, false);
        int rc = this.DbControl.getErrorCode();
        if (rc != 0) {
            return rc;
        }
        this.fd = new DBHandle(this.DbControl.DbFileMapfp(1), 1);
        if (this.fd.getPtr() == 0) {
            return 53;
        }
        boolean result = this.DbControl.getFrame(this.fd);
        if (this.fd.getMappedBuf() != null) {
            this.mappedMapframe = this.fd.getMappedBuf();
        } else {
            this.unmappedMapframe = this.fd.getUnmappedBuf();
        }
        this.mapfIdx = this.fd.getBufIndex();
        this.dh = null;
        this.curse = new DomainCursor(this.DbControl);
        rc = this.curse.loadOpen(null, false);
        this.dh = this.curse.getDBLHandle();
        return rc;
    }

    private int CloseInputFile() {
        int rc = this.loadClose();
        this.closeSimple();
        return rc;
    }

    private int loadClose() {
        if (this.dh != null) {
            int status = this.dh.closeLoad(null, false);
            this.dh = null;
            return status;
        }
        return 113;
    }

    private void closeSimple() {
        this.DbControl.close();
        this.DbControl = null;
    }

    private int OpenOutputFile(File outFile) {
        this.tblfile = new TBLFile(this.DbControl);
        int rc = this.tblfile.create(outFile, 0, 0, 16);
        if (rc != 0) {
            return rc;
        }
        this.tblhand = new TBLHandle();
        this.tblhand.attachFile(this.tblfile);
        if (this.proto_table != null) {
            this.TblProtos();
        }
        return 0;
    }

    private int CloseOutputFile() {
        this.tblfile.close();
        if (this.proto_table != null) {
            this.proto_table.delete();
        }
        this.tblhand = null;
        return 0;
    }

    private void CleanProtos() {
        TBLStruct lag = null;
        TBLStruct def = this.proto_table.layout;
        while (def != null) {
            if (def.type == 0 && def.name.charAt(0) != '_') {
                if (lag == null) {
                    this.proto_table.layout = def.next;
                } else {
                    lag.next = def.next;
                }
                TBLStruct temp = def;
                def = def.next;
                temp.next = null;
                temp.delete();
                continue;
            }
            lag = def;
            def = def.next;
        }
    }

    private void TblProtos() {
        this.CleanProtos();
        this.tblfile.protos = this.proto_table;
        this.tblfile.protos = this.tblfile.TblCopyTable(this.proto_table.layout, null, null);
    }

    private int CvtTraverseInternal(DomainString section) {
        int rc = this.tblhand.newSection(section.toString(), false);
        DomainString tag = new DomainString();
        DomainString value = new DomainString();
        rc = this.dh.loadFirst(tag, value);
        while (rc == 0) {
            rc = this.tblhand.newTag(tag.toString(), value.toString(), false);
            if (rc != 0) {
                return rc;
            }
            rc = this.dh.loadNext(tag, value);
        }
        int tbl = this.dh.DbLoadTableFP();
        if (tbl != 0 && (rc = this.ConvertTblTable(tbl)) != 0) {
            return rc;
        }
        boolean hadkids = false;
        rc = this.dh.loadFirstSection(section);
        while (rc == 0) {
            rc = this.CvtTraverseInternal(section);
            if (rc != 0) {
                return rc;
            }
            hadkids = true;
            rc = this.dh.loadNextSection(section);
        }
        if (hadkids) {
            this.dh.loadSection("..");
        }
        return this.tblhand.parentSection();
    }

    private int CvtTraverse(DomainString root) {
        String rootStr = root.toString();
        int rc = this.dh.loadSection(rootStr);
        if (rc == 0) {
            rc = this.CvtTraverseInternal(root);
        }
        return rc;
    }

    private DBControl DbOpenSimple(String filename, boolean failOnError) throws DomainException {
        DBControl dbc = new DBControl(null, false, failOnError);
        dbc.openResources(true, null, null);
        dbc.putResource("Database/Path", filename);
        dbc.open();
        return dbc;
    }

    private int ReadProtos() {
        DomainEcNumber mptr = this.mappedMapframe != null ? new DomainEcNumber(this.mappedMapframe, this.mapfIdx) : new DomainEcNumber(this.unmappedMapframe, this.mapfIdx);
        while (mptr.getOffset() < mptr.getLen() - 1) {
            DomainString section = mptr.getEcString();
            int fp = mptr.getEcNumber();
            int flags = mptr.getEcNumber();
            if (section.compareTo("_prototypes_%R") != 0) continue;
            this.fd.setPtr(fp);
            this.DbControl.getFrame(this.fd);
            mptr = this.fd.getMappedBuf() != null ? new DomainEcNumber(this.fd.getMappedBuf(), this.fd.getBufIndex()) : new DomainEcNumber(this.fd.getUnmappedBuf(), this.fd.getBufIndex());
            this.proto_table = new TBLTable();
            this.proto_table.tblFlags |= 0x40;
            int rc = this.proto_table.unCompactStruct(mptr, 4, this.proto_table, null);
            if (rc != 0) {
                return rc;
            }
            rc = this.proto_table.restoreLinks(this.proto_table.layout);
            if (rc == 0) break;
            return rc;
        }
        return 0;
    }

    private int ConvertTblTable(int tbl) {
        int rc;
        TBLTable master;
        int i2;
        this.fd.setPtr(tbl);
        this.DbControl.getFrame(this.fd);
        DomainEcNumber inpage = this.fd.getMappedBuf() != null ? new DomainEcNumber(this.fd.getMappedBuf(), this.fd.getBufIndex()) : new DomainEcNumber(this.fd.getUnmappedBuf(), this.fd.getBufIndex());
        int tables = inpage.getEcNumber();
        int pages = inpage.getEcNumber();
        if (pages == 0) {
            return 54;
        }
        int[] taddr = new int[tables];
        int[] paddr = new int[pages];
        for (i2 = 0; i2 < tables; ++i2) {
            taddr[i2] = inpage.getEcNumber();
        }
        for (i2 = 0; i2 < pages; ++i2) {
            paddr[i2] = inpage.getEcNumber();
        }
        TBLTable[] tabAry = new TBLTable[1];
        int baseOffset = this.tblfile.TblUnCompactTableStart(tabAry, pages);
        TBLTable table = master = tabAry[0];
        for (i2 = 0; i2 < tables; ++i2) {
            this.fd.setPtr(taddr[i2]);
            this.DbControl.getFrame(this.fd);
            rc = this.tblfile.TblUnCompactTableDefinition(master, table, this.fd.getMappedBuf(), this.fd.getUnmappedBuf(), this.fd.getBufIndex(), baseOffset, i2 > 0);
            if (rc == 0) continue;
            return rc;
        }
        for (i2 = 0; i2 < pages; ++i2) {
            this.fd.setPtr(paddr[i2]);
            this.DbControl.getFrame(this.fd);
            rc = this.tblfile.TblUnCompactTablePage(i2 + 1, baseOffset, this.fd.getMappedBuf(), this.fd.getUnmappedBuf(), this.fd.getBufIndex());
            if (rc == 0) continue;
            return rc;
        }
        rc = this.tblhand.TblAttachTable(master);
        master.delete();
        return rc;
    }
}

