/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBHandle;
import com.mmmhis.domain.ec.EcUtil;
import com.mmmhis.domain.le.LEHandle;
import com.mmmhis.domain.table.TBLCompaction;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLPageCtl;
import com.mmmhis.domain.table.TBLSpace;
import com.mmmhis.domain.table.TBLStruct;
import com.mmmhis.domain.table.TBLTable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class TBLFile {
    public static final int TblFLAG_DISKLESS = 1;
    public static final int TblFLAG_READONLY = 2;
    public static final int TblFLAG_DEFINED = 4;
    public static final int TblFLAG_MASTER = 8;
    public static final int TblFLAG_MODIFIED = 16;
    public static final int TblFLAG_DBENGINE = 32;
    public static final int TblFLAG_PROTOTYPE = 64;
    public static final int TblFLAG_CLUSTERED = 128;
    public static final int TblFLAG_PACKED = 256;
    public static final int TblFLAG_ROWACCESS = 512;
    public static final int TblFLAG_CONSOLID = 1024;
    public static final int TblFLAG_ONEPAGE = 2048;
    public static final int TblFLAG_GEV41 = 4096;
    public static final int Tbl_OK = 0;
    public static final int Tbl_LOW = 1;
    public static final int Tbl_ERROR = 2;
    public static final int Tbl_HIGH = 3;
    public static final int Tbl_DUPLICATE = 4;
    public static final int Tbl_DELETED = 5;
    public static final int Tbl_EMPTY = 6;
    public static final int Tbl_BADFILE = 7;
    public static final int Tbl_BADGMMF = 8;
    public static final int Tbl_MEMORY = 9;
    public static final int Tbl_IOERR = 10;
    public static final int Tbl_NOTOPEN = 11;
    public static final int Tbl_BADROOT = 12;
    public static final int Tbl_FULL = 13;
    public static final int Tbl_NORECORD = 14;
    public static final int Tbl_END = 15;
    public static final int Tbl_DEEP = 16;
    public static final int Tbl_RECORDLEN = 17;
    public static final int Tbl_NOTDEFINED = 18;
    public static final int Tbl_TOOMANYCOLS = 19;
    public static final int Tbl_OBRACE_BAD = 20;
    public static final int Tbl_NOTENDED = 21;
    public static final int Tbl_SETUP_ERR = 22;
    public static final int Tbl_SYNTAX_ERR = 23;
    public static final int Tbl_UNKNOWN_STRUCT = 24;
    public static final int Tbl_STMT_OUT_OF_PLACE = 25;
    public static final int Tbl_INDEX_KEY_UNKNOWN = 26;
    public static final int Tbl_DIM_MISMATCH = 27;
    public static final int Tbl_BAD_KEY_EXPRN = 28;
    public static final int Tbl_CORRUPT = 29;
    public static final int Tbl_BIT_NAME_ERROR = 30;
    public static final int Tbl_CURSOR_NOT_READY = 31;
    public static final int Tbl_CURSOR_NOT_POSITIONED = 32;
    public static final int Tbl_COMPACT_WRITE = 33;
    public static final int Tbl_UNCOMPACT_ERR = 34;
    public static final int Tbl_NODELETE = 35;
    public static final int Tbl_READONLY = 36;
    public static final int Tbl_BADDATE = 37;
    public static final int Tbl_TAGTOOBIG = 38;
    public static final int Tbl_VERSION = 39;
    public static final int Tbl_SAVEERR = 40;
    public static final int Tbl_NOCOLS = 41;
    public static final int Tbl_NODATA = 42;
    public static final int Tbl_NOSECTION = 43;
    public static final int Tbl_BADPATH = 44;
    public static final int Tbl_NOPLACE = 45;
    public static final int Tbl_NOTAG = 46;
    public static final int Tbl_ROWTOOLONG = 47;
    public static final int Tbl_BADORDER = 48;
    public static final int Tbl_BADINDEX = 49;
    public static final int Tbl_CLUSTER_ERR = 50;
    public static final int Tbl_NO_MAPFRAME = 53;
    public static final int Tbl_INVNAME = 55;
    public static final int KeSTATUS_CODENOTFOUND = 130;
    public static final int KeSTATUS_DIRNOTFOUND = 131;
    public static final int KeSTATUS_DIRALREADYEXISTS = 132;
    public static final int KeSTATUS_SIMPLEDIR = 133;
    public static final int KeSTATUS_DELETEPWD = 134;
    public static final int TblTBLTYPE_RELATIVE = 0;
    public static final int TblTBLTYPE_KEYED = 1;
    public static final int TblTBLTYPE_UNIQUE = 2;
    public static final int NON_UNIX_MAX_BLKS = 8192;
    public static final int TBL_MINIMUM_CACHE = 16;
    public static final int TBL_GMMF_INCREMENT = 65536;
    public static final int TBL_DEFAULT_INCREMENT = 64;
    public static final int TBL_DEFAULT_FILESIZE = 64;
    public static final int TBL_MINIMUM_CACHESIZE = 64;
    public static final int TblSAVE_ITEM_VERSN = 5;
    public static final int TblSAVE_ITEM_FILE = 1;
    public static final int TblSAVE_ITEM_SECT = 2;
    public static final int TblSAVE_ITEM_TABLE = 3;
    public static final int TblSAVE_ITEM_LAYOUT = 4;
    public static final int TblSAVE_ITEM_STRUCT = 5;
    public static final int TblSAVE_ITEM_ARRAY = 6;
    public static final int TblSAVE_ITEM_COLUMN = 7;
    public static final int TblSAVE_FILE_ID = 0;
    public static final int TblSAVE_FILE_VERSN = 1;
    public static final int TblSAVE_FILE_PAGE = 2;
    public static final int TblSAVE_FILE_SECT = 4;
    public static final int TblSAVE_FILE_AVAIL = 8;
    public static final int TblSAVE_FILE_LEFT = 12;
    public static final int TblSAVE_FILE_PROTO = 14;
    public static final int TblSAVE_FILE_RECLEN = 18;
    public static final int TblSAVE_SECT_ID = 0;
    public static final int TblSAVE_SECT_NEXT = 1;
    public static final int TblSAVE_SECT_PARENT = 5;
    public static final int TblSAVE_SECT_KIDS = 9;
    public static final int TblSAVE_SECT_TAGS = 13;
    public static final int TblSAVE_SECT_TABLE = 17;
    public static final int TblSAVE_SECT_NAME = 21;
    public static final int TblSAVE_SECT_RECLEN = 22;
    public static final int TblSAVE_TABLE_ID = 0;
    public static final int TblSAVE_TABLE_ROOT = 1;
    public static final int TblSAVE_TABLE_TYPE = 5;
    public static final int TblSAVE_TABLE_LEAF = 6;
    public static final int TblSAVE_TABLE_SOFF = 8;
    public static final int TblSAVE_TABLE_SCNT = 10;
    public static final int TblSAVE_TABLE_BLEN = 12;
    public static final int TblSAVE_TABLE_KLEN = 14;
    public static final int TblSAVE_TABLE_FLAG = 16;
    public static final int TblSAVE_TABLE_SID = 18;
    public static final int TblSAVE_TABLE_RECS = 20;
    public static final int TblSAVE_TABLE_LAYO = 24;
    public static final int TblSAVE_TABLE_MAST = 28;
    public static final int TblSAVE_TABLE_INDX = 32;
    public static final int TblSAVE_TABLE_NCOL = 36;
    public static final int TblSAVE_TABLE_FLEN = 38;
    public static final int TblSAVE_TABLE_FORM = 40;
    public static final int TblSAVE_TABLE_DRECS = 44;
    public static final int TblSAVE_TABLE_RECLEN = 48;
    public static final int TblSAVE_FORMAT_MAX = 1000;
    public static final int TblSAVE_STRU_CODE = 0;
    public static final int TblSAVE_STRU_NEXT = 1;
    public static final int TblSAVE_STRU_BACK = 5;
    public static final int TblSAVE_STRU_COMP = 9;
    public static final int TblSAVE_STRU_TYPE = 13;
    public static final int TblSAVE_STRU_ELEM = 14;
    public static final int TblSAVE_STRU_OFF = 16;
    public static final int TblSAVE_STRU_LEN = 18;
    public static final int TblSAVE_STRU_MASK = 20;
    public static final int TblSAVE_STRU_DT = 21;
    public static final int TblSAVE_STRU_ISTR = 22;
    public static final int TblSAVE_STRU_NSTR = 24;
    public static final int TblSAVE_STRU_ICOL = 26;
    public static final int TblSAVE_STRU_NCOL = 28;
    public static final int TblSAVE_STRU_PREC = 30;
    public static final int TblSAVE_STRU_SRCO = 31;
    public static final int TblSAVE_STRU_SRCS = 33;
    public static final int TblSAVE_STRU_SRCC = 35;
    public static final int TblSAVE_STRU_NAME = 37;
    public static final int TblSAVE_STRU_RECLEN = 38;
    TBLPage absPage = new TBLPage(false);
    TBLPage mruBlk;
    TBLPage lruBlk;
    TBLPage[] refArray;
    int maxblks;
    int cachesize;
    int cached;
    RandomAccessFile hFile;
    int endOffset;
    int fileFlags;
    int pageSize;
    int rootOffset;
    int spcAvail;
    int spcLeft;
    int spcPage;
    boolean readOnly;
    TBLTable protos;
    DBHandle dbh;
    int numpages;
    int[] pageTrans;
    DBControl dbControl;

    public TBLFile() {
        this.hFile = null;
        this.mruBlk = null;
        this.lruBlk = null;
        this.readOnly = true;
    }

    public TBLFile(DBControl dbControl) {
        this.dbControl = dbControl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getCacheLevel() {
        return this.cached;
    }

    public int getFileSize() {
        return this.endOffset;
    }

    public int getRootOffset() {
        return this.rootOffset;
    }

    public int create(File file, int pagesize, int maxsize, int cache) throws DomainException {
        if (pagesize <= 0) {
            pagesize = 4096;
        }
        this.pageSize = pagesize;
        if (maxsize <= 0) {
            maxsize = 64;
        }
        this.maxblks = (int)((long)maxsize * 1024L * 1024L / (long)this.pageSize);
        if (file != null) {
            boolean success;
            if (file.exists() && file.isDirectory()) {
                return 7;
            }
            if (file.exists() && file.isFile() && !(success = file.delete())) {
                return 7;
            }
            try {
                this.hFile = new RandomAccessFile(file, "rw");
            }
            catch (IOException ex) {
                return 7;
            }
            this.cachesize = (int)((long)cache * 1024L * 1024L) / this.pageSize;
        } else {
            this.cachesize = this.maxblks;
            this.fileFlags |= 1;
            this.hFile = null;
        }
        if (this.cachesize < 16) {
            this.cachesize = 16;
        }
        this.refArray = new TBLPage[this.maxblks];
        int off = this.allocSpace(18);
        if (off == 0 || off != 16) {
            this.close();
            return 9;
        }
        TBLPage[] page = new TBLPage[1];
        int ctlblk = this.referSpace(off, page);
        if (page[0].mappedBuffer != null) {
            DomainByteArrayFileMap.fill(page[0].mappedBuffer, ctlblk, ctlblk + 16 - 1, (byte)0);
        } else {
            Arrays.fill(page[0].unmappedBuffer, ctlblk, ctlblk + 16 - 1, (byte)0);
        }
        page[0].modifiedPage();
        return 0;
    }

    public int open(String fileName, boolean readOnly, int maxincr, int cache) throws DomainException {
        this.pageSize = 4096;
        if (readOnly) {
            this.fileFlags |= 2;
        }
        if (readOnly) {
            maxincr = 0;
        } else if (maxincr <= 0) {
            maxincr = 64;
        }
        try {
            this.hFile = readOnly ? new RandomAccessFile(fileName, "r") : new RandomAccessFile(fileName, "rw");
            this.endOffset = (int)this.hFile.length();
        }
        catch (IOException ex) {
            return 7;
        }
        this.cachesize = (int)((long)cache * 1024L * 1024L) / this.pageSize;
        if (this.cachesize < 16) {
            this.cachesize = 16;
        }
        this.maxblks = (int)((long)this.endOffset + (long)maxincr * 1024L * 1024L) / this.pageSize;
        this.refArray = new TBLPage[this.maxblks];
        int rc = this.restoreFile();
        if (rc != 0) {
            this.close();
            return rc;
        }
        return 0;
    }

    public int close() throws DomainException {
        TBLPage bb;
        int rc;
        if ((this.fileFlags & 2) == 0 && (rc = this.save()) != 0) {
            return rc;
        }
        if (this.protos != null) {
            this.protos.delete();
        }
        while ((bb = this.lruBlk) != null) {
            TBLPageCtl bbpc = bb.getControlPart();
            this.lruBlk = bbpc.mruPtr;
            if (!bbpc.isDirty()) continue;
            this.writeToDisk(bb);
        }
        this.mruBlk = null;
        this.lruBlk = null;
        this.cached = 0;
        if (this.refArray != null) {
            this.refArray = null;
            this.maxblks = 0;
        }
        try {
            if (this.hFile != null) {
                this.hFile.close();
                this.hFile = null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return 0;
    }

    public void flush() {
    }

    public int save() throws DomainException {
        if ((this.fileFlags & 2) == 2) {
            return 36;
        }
        TBLPage[] pages = new TBLPage[1];
        int rec = this.referSpace(16, pages);
        TBLPage page = pages[0];
        if (rec == 0) {
            return 40;
        }
        if (page.mappedBuffer != null) {
            TBLStruct layout;
            int[] rslt;
            int rc;
            if (this.protos != null && TBLTable.getLong(page.mappedBuffer, rec + 14) == 0L && (rc = this.saveStruct(0, page, rslt = new int[]{rec + 14}, 4, layout = this.protos.layout)) != 0) {
                return rc;
            }
            page.mappedBuffer.putByte(rec + 0, (byte)1);
            page.mappedBuffer.putByte(rec + 1, (byte)5);
            TBLTable.putShort(page.mappedBuffer, rec + 2, (short)this.pageSize);
            TBLTable.putLong(page.mappedBuffer, rec + 4, (long)this.rootOffset);
            TBLTable.putLong(page.mappedBuffer, rec + 8, (long)this.spcAvail);
            TBLTable.putShort(page.mappedBuffer, rec + 12, (short)this.spcLeft);
        } else {
            TBLStruct layout;
            int[] rslt;
            int rc;
            if (this.protos != null && TBLTable.getLong(page.unmappedBuffer, rec + 14) == 0L && (rc = this.saveStruct(0, page, rslt = new int[]{rec + 14}, 4, layout = this.protos.layout)) != 0) {
                return rc;
            }
            page.unmappedBuffer[rec + 0] = 1;
            page.unmappedBuffer[rec + 1] = 5;
            TBLTable.putShort(page.unmappedBuffer, rec + 2, (short)this.pageSize);
            TBLTable.putLong(page.unmappedBuffer, rec + 4, (long)this.rootOffset);
            TBLTable.putLong(page.unmappedBuffer, rec + 8, (long)this.spcAvail);
            TBLTable.putShort(page.unmappedBuffer, rec + 12, (short)this.spcLeft);
        }
        page.modifiedPage();
        return 0;
    }

    int saveTable(int parent, TBLPage page, int[] rslt, TBLTable table) throws DomainException {
        while (table != null) {
            int[] iArr;
            int rc;
            TBLStruct layout;
            int foff;
            int off = table.address;
            if (off == 0) {
                off = this.allocSpace(48);
            }
            TBLPage[] pages = new TBLPage[1];
            int rec = this.referSpace(off, pages);
            TBLPage recPage = pages[0];
            if (rec == 0) {
                return 40;
            }
            if (page.mappedBuffer != null) {
                TBLTable.putLong(page.mappedBuffer, rslt[0], (long)off);
                if (table.address == 0) {
                    DomainByteArrayFileMap.fill(recPage.mappedBuffer, rec, rec + 48 - 1, (byte)0);
                    table.address = off;
                }
                recPage.mappedBuffer.putByte(rec + 0, (byte)3);
                TBLTable.putLong(recPage.mappedBuffer, rec + 1, (long)table.rootOffset);
                recPage.mappedBuffer.putByte(rec + 5, (byte)table.tblType);
                TBLTable.putShort(recPage.mappedBuffer, rec + 6, (short)table.leafRowLen);
                TBLTable.putShort(recPage.mappedBuffer, rec + 8, (short)table.strOff);
                TBLTable.putShort(recPage.mappedBuffer, rec + 10, (short)table.strCount);
                TBLTable.putShort(recPage.mappedBuffer, rec + 12, (short)table.brRowLen);
                TBLTable.putShort(recPage.mappedBuffer, rec + 14, (short)table.keyLen);
                TBLTable.putShort(recPage.mappedBuffer, rec + 16, (short)(table.tblFlags & 0x178C));
                TBLTable.putShort(recPage.mappedBuffer, rec + 18, (short)table.strucId);
                TBLTable.putLong(recPage.mappedBuffer, rec + 20, (long)table.recCount);
                TBLTable.putLong(recPage.mappedBuffer, rec + 44, (long)table.delCount);
                TBLTable.putLong(recPage.mappedBuffer, rec + 28, (long)parent);
                TBLTable.putShort(recPage.mappedBuffer, rec + 36, (short)table.numCols);
                if ((table.tblFlags & 0x10) == 16) {
                    if (table.formLen != 0 && table.colForm != null) {
                        TBLTable.putShort(recPage.mappedBuffer, rec + 38, (short)table.formLen);
                        foff = this.saveFormat(table.colForm, 0, table.formLen);
                        if (foff == 0) {
                            return 40;
                        }
                        TBLTable.putLong(recPage.mappedBuffer, rec + 40, (long)foff);
                    }
                    if ((layout = table.layout) != null && (rc = this.saveStruct(0, recPage, iArr = new int[]{rec + 24}, 4, layout)) != 0) {
                        return rc;
                    }
                    table.tblFlags &= 0xFFFFFFEF;
                }
            } else {
                TBLTable.putLong(page.unmappedBuffer, rslt[0], (long)off);
                if (table.address == 0) {
                    Arrays.fill(recPage.unmappedBuffer, rec, rec + 48 - 1, (byte)0);
                    table.address = off;
                }
                recPage.unmappedBuffer[rec + 0] = 3;
                TBLTable.putLong(recPage.unmappedBuffer, rec + 1, (long)table.rootOffset);
                recPage.unmappedBuffer[rec + 5] = (byte)table.tblType;
                TBLTable.putShort(recPage.unmappedBuffer, rec + 6, (short)table.leafRowLen);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 8, (short)table.strOff);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 10, (short)table.strCount);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 12, (short)table.brRowLen);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 14, (short)table.keyLen);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 16, (short)(table.tblFlags & 0x178C));
                TBLTable.putShort(recPage.unmappedBuffer, rec + 18, (short)table.strucId);
                TBLTable.putLong(recPage.unmappedBuffer, rec + 20, (long)table.recCount);
                TBLTable.putLong(recPage.unmappedBuffer, rec + 44, (long)table.delCount);
                TBLTable.putLong(recPage.unmappedBuffer, rec + 28, (long)parent);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 36, (short)table.numCols);
                if ((table.tblFlags & 0x10) == 16) {
                    if (table.formLen != 0 && table.colForm != null) {
                        TBLTable.putShort(recPage.unmappedBuffer, rec + 38, (short)table.formLen);
                        foff = this.saveFormat(table.colForm, 0, table.formLen);
                        if (foff == 0) {
                            return 40;
                        }
                        TBLTable.putLong(recPage.unmappedBuffer, rec + 40, (long)foff);
                    }
                    if ((layout = table.layout) != null && (rc = this.saveStruct(0, recPage, iArr = new int[]{rec + 24}, 4, layout)) != 0) {
                        return rc;
                    }
                    table.tblFlags &= 0xFFFFFFEF;
                }
            }
            if (parent == 0) {
                parent = off;
            }
            rslt[0] = rec + 32;
            page = recPage;
            table = table.nextIndex;
        }
        return 0;
    }

    int saveFormat(byte[] fmt, int fmtIndex, int fmtlen) throws DomainException {
        int foff = 0;
        int fmore = 0;
        if (fmtlen > 1000) {
            fmore = this.saveFormat(fmt, fmtIndex + 1000, fmtlen - 1000);
            if (fmore == 0) {
                return fmore;
            }
            fmtlen = 1000;
        }
        foff = this.allocSpace(fmtlen + 4);
        TBLPage[] pages = new TBLPage[1];
        int frec = this.referSpace(foff, pages);
        TBLPage frecPage = pages[0];
        if (frec == 0) {
            return 0;
        }
        if (frecPage.mappedBuffer != null) {
            TBLTable.putLong(frecPage.mappedBuffer, frec, (long)fmore);
            DomainByteArrayFileMap.arraycopy(fmt, fmtIndex, frecPage.mappedBuffer, frec + 4, fmtlen);
        } else {
            TBLTable.putLong(frecPage.unmappedBuffer, frec, (long)fmore);
            System.arraycopy(fmt, fmtIndex, frecPage.unmappedBuffer, frec + 4, fmtlen);
        }
        return foff;
    }

    int saveStruct(int parent, TBLPage page, int[] rslt, int itype, TBLStruct def) throws DomainException {
        int[] iArr = new int[1];
        while (def != null) {
            int len = 0;
            if (def.type == 5 && (def.datatype == 11 || def.datatype == 17)) {
                len = 1 + def.components.name.length();
            }
            int off = this.allocSpace(38 + len + def.name.length());
            TBLPage[] pages = new TBLPage[1];
            int rec = this.referSpace(off, pages);
            TBLPage recPage = pages[0];
            if (rec == 0) {
                return 40;
            }
            if (page.mappedBuffer != null) {
                TBLTable.putLong(page.mappedBuffer, rslt[0], (long)off);
                DomainByteArrayFileMap.fill(recPage.mappedBuffer, rec, rec + 38 - 1, (byte)0);
                if (len != 0) {
                    EcUtil.strcpy(recPage.mappedBuffer, rec + 37, def.components.name.toByteArray(), 0);
                }
                EcUtil.strcpy(recPage.mappedBuffer, rec + 37 + len, def.name.toByteArray(), 0);
                recPage.mappedBuffer.putByte(rec + 0, (byte)itype);
                TBLTable.putLong(recPage.mappedBuffer, rec + 5, (long)parent);
                recPage.mappedBuffer.putByte(rec + 13, (byte)def.type);
                TBLTable.putShort(recPage.mappedBuffer, rec + 14, (short)def.elements);
                TBLTable.putShort(recPage.mappedBuffer, rec + 16, (short)def.offset);
                TBLTable.putShort(recPage.mappedBuffer, rec + 18, (short)def.length);
                recPage.mappedBuffer.putByte(rec + 20, (byte)def.bitmask);
                recPage.mappedBuffer.putByte(rec + 21, (byte)def.datatype);
                TBLTable.putShort(recPage.mappedBuffer, rec + 22, (short)def.strix);
                TBLTable.putShort(recPage.mappedBuffer, rec + 24, (short)def.numstr);
                TBLTable.putShort(recPage.mappedBuffer, rec + 26, (short)def.coloff);
                TBLTable.putShort(recPage.mappedBuffer, rec + 28, (short)def.numcol);
                recPage.mappedBuffer.putByte(rec + 30, (byte)def.precision);
                TBLTable.putShort(recPage.mappedBuffer, rec + 31, (short)def.srcOffset);
                TBLTable.putShort(recPage.mappedBuffer, rec + 33, (short)def.srcString);
                TBLTable.putShort(recPage.mappedBuffer, rec + 35, (short)def.srcColumn);
            } else {
                TBLTable.putLong(page.unmappedBuffer, rslt[0], (long)off);
                Arrays.fill(recPage.unmappedBuffer, rec, rec + 38 - 1, (byte)0);
                if (len != 0) {
                    EcUtil.strcpy(recPage.unmappedBuffer, rec + 37, def.components.name.toByteArray(), 0);
                }
                EcUtil.strcpy(recPage.unmappedBuffer, rec + 37 + len, def.name.toByteArray(), 0);
                recPage.unmappedBuffer[rec + 0] = (byte)itype;
                TBLTable.putLong(recPage.unmappedBuffer, rec + 5, (long)parent);
                recPage.unmappedBuffer[rec + 13] = (byte)def.type;
                TBLTable.putShort(recPage.unmappedBuffer, rec + 14, (short)def.elements);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 16, (short)def.offset);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 18, (short)def.length);
                recPage.unmappedBuffer[rec + 20] = (byte)def.bitmask;
                recPage.unmappedBuffer[rec + 21] = (byte)def.datatype;
                TBLTable.putShort(recPage.unmappedBuffer, rec + 22, (short)def.strix);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 24, (short)def.numstr);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 26, (short)def.coloff);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 28, (short)def.numcol);
                recPage.unmappedBuffer[rec + 30] = (byte)def.precision;
                TBLTable.putShort(recPage.unmappedBuffer, rec + 31, (short)def.srcOffset);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 33, (short)def.srcString);
                TBLTable.putShort(recPage.unmappedBuffer, rec + 35, (short)def.srcColumn);
            }
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    iArr[0] = rec + 9;
                    int rc = this.saveStruct(off, recPage, iArr, 7, def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    iArr[0] = rec + 9;
                    int rc = this.saveStruct(off, recPage, iArr, 6, def.components);
                    if (rc == 0) break;
                    return rc;
                }
            }
            rslt[0] = rec + 1;
            page = recPage;
            if (itype == 4) {
                itype = 5;
            }
            def = def.next;
        }
        return 0;
    }

    TBLPage allocPage() {
        TBLPage newb = null;
        newb = this.getPageSpace();
        newb.initPage(this.pageSize);
        TBLPageCtl ctl = newb.getControlPart();
        ctl.blkFlags = 0;
        ctl.blkOffset = this.endOffset;
        ctl.refIndex = ctl.blkOffset / this.pageSize;
        this.endOffset += this.pageSize;
        this.refArray[ctl.refIndex] = newb;
        this.writeToDisk(newb);
        return newb;
    }

    int allocSpace(int needed) throws DomainException {
        TBLPage pg;
        int found = 0;
        if (needed <= this.spcLeft) {
            TBLSpace space = this.referSpace(this.spcAvail);
            pg = space.page;
        } else {
            pg = this.allocPage();
            this.spcPage = this.getPageOffset(pg);
            pg.setRecords(65535, false);
            this.spcAvail = this.spcPage + 16;
            this.spcLeft = this.pageSize - 16;
        }
        found = this.spcAvail;
        this.spcAvail += needed;
        this.spcLeft -= needed;
        pg.setRowData(pg.getPageRowData() + needed);
        pg.modifiedPage();
        return found;
    }

    public TBLSpace referSpace(int offset) throws DomainException {
        if (offset >= this.endOffset) {
            throw new DomainException("Attempt access beyond end of file");
        }
        int pagenum = offset / this.pageSize;
        int pagebeg = pagenum * this.pageSize;
        TBLPage page = this.absolutePage(pagebeg);
        return new TBLSpace(page.pagelen + (offset - pagebeg), page);
    }

    public int referSpace(int offset, TBLPage[] pageArr) throws DomainException {
        if (offset >= this.endOffset) {
            if (pageArr != null) {
                pageArr[0] = null;
            }
            return -1;
        }
        int pagenum = offset / this.pageSize;
        int pagebeg = pagenum * this.pageSize;
        TBLPage page = this.absolutePage(pagebeg);
        if (pageArr != null) {
            pageArr[0] = page;
        }
        return page.pagelen + (offset - pagebeg);
    }

    TBLPage absolutePage(int offset) throws DomainException {
        if ((this.fileFlags & 0x20) == 32) {
            this.dbh.setPtr(this.pageTrans[offset - 1]);
            this.dbControl.getFrame(this.dbh);
            if (this.dbh.getMappedBuf() != null) {
                DomainByteArrayFileMap mappedPtr = this.dbh.getMappedBuf();
                int bufIndex = this.dbh.getBufIndex();
                bufIndex += DomainEcNumber.EcSkipNumber(mappedPtr, bufIndex);
                this.dbh.setBufIndex(bufIndex);
                if (this.absPage == null) {
                    this.absPage = new TBLPage(true);
                }
                this.absPage.assignParts(mappedPtr, bufIndex);
            } else {
                byte[] unmappedPtr = this.dbh.getUnmappedBuf();
                int bufIndex = this.dbh.getBufIndex();
                bufIndex += DomainEcNumber.EcSkipNumber(unmappedPtr, bufIndex);
                this.dbh.setBufIndex(bufIndex);
                if (this.absPage == null) {
                    this.absPage = new TBLPage(false);
                }
                this.absPage.assignParts(unmappedPtr, bufIndex);
            }
            return this.absPage;
        }
        TBLPage blk = this.refArray[offset / this.pageSize];
        if (blk != null) {
            this.mostRecent(blk);
            return blk;
        }
        blk = this.getPageSpace();
        if (blk == null) {
            return blk;
        }
        TBLPageCtl ctl = blk.getControlPart();
        ctl.blkOffset = offset;
        ctl.blkFlags = 0;
        ctl.refIndex = offset / this.pageSize;
        this.refArray[ctl.refIndex] = blk;
        if ((this.fileFlags & 1) == 1) {
            return blk;
        }
        try {
            this.hFile.seek(offset);
            if (blk.mappedBuffer != null) {
                this.hFile.read(blk.mappedBuffer.getPage(offset));
            } else {
                this.hFile.read(blk.unmappedBuffer);
            }
            blk.assignParts(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return blk;
    }

    int getPageOffset(TBLPage page) {
        TBLPageCtl ctl = null;
        if ((this.fileFlags & 0x20) == 32) {
            if (page.mappedBuffer != null) {
                return (int)TBLTable.getLong(page.mappedBuffer, page.pagelen + TBLTable.getShort(page.mappedBuffer, page.pagelen));
            }
            return (int)TBLTable.getLong(page.unmappedBuffer, page.pagelen + TBLTable.getShort(page.unmappedBuffer, page.pagelen));
        }
        ctl = page.getControlPart();
        return ctl.blkOffset;
    }

    void holdPage(TBLPage pg) {
        if ((this.fileFlags & 0x20) == 32) {
            return;
        }
        TBLPageCtl ctl = pg.getControlPart();
        ctl.holdPage();
    }

    void releasePage(TBLPage pg) {
        if ((this.fileFlags & 0x20) == 32) {
            return;
        }
        if (pg != null) {
            TBLPageCtl ctl = pg.getControlPart();
            ctl.releasePage();
        }
    }

    void mostRecent(TBLPage blk) {
        TBLPageCtl linkc;
        if (blk == this.mruBlk) {
            return;
        }
        TBLPageCtl ctl = blk.getControlPart();
        TBLPage linkb = ctl.mruPtr;
        if (linkb != null) {
            linkc = linkb.getControlPart();
            linkc.lruPtr = ctl.lruPtr;
        }
        if ((linkb = ctl.lruPtr) != null) {
            linkc = linkb.getControlPart();
            linkc.mruPtr = ctl.mruPtr;
        } else if (this.lruBlk == blk) {
            this.lruBlk = ctl.mruPtr;
        }
        ctl.lruPtr = this.mruBlk;
        if (ctl.lruPtr != null) {
            linkb = ctl.lruPtr;
            linkc = linkb.getControlPart();
            linkc.mruPtr = blk;
        } else {
            this.lruBlk = blk;
        }
        ctl.mruPtr = null;
        this.mruBlk = blk;
    }

    TBLPage getPageSpace() throws DomainException {
        TBLPage newb;
        if (this.cached >= this.cachesize) {
            if ((this.fileFlags & 1) == 0) {
                newb = this.lruBlk;
                while (newb != null) {
                    TBLPageCtl ctl = newb.getControlPart();
                    if (!ctl.isOnHold()) {
                        if (ctl.isDirty()) {
                            this.writeToDisk(newb);
                        }
                        this.refArray[ctl.refIndex] = null;
                        this.mostRecent(newb);
                        return newb;
                    }
                    newb = ctl.mruPtr;
                }
            }
            this.cachesize = this.cached + 1;
        }
        if (this.absPage.mappedBuffer != null) {
            newb = new TBLPage(true);
            TBLTable.putShort(newb.mappedBuffer, newb.pagelen, (short)this.pageSize);
        } else {
            newb = new TBLPage(false);
            TBLTable.putShort(newb.unmappedBuffer, newb.pagelen, (short)this.pageSize);
        }
        ++this.cached;
        this.mostRecent(newb);
        return newb;
    }

    void writeToDisk(TBLPage blk) throws DomainException {
        TBLPageCtl ctl = blk.getControlPart();
        if ((this.fileFlags & 1) == 1) {
            ctl.setDirty(false);
            return;
        }
        try {
            this.hFile.seek(ctl.blkOffset);
            if (blk.mappedBuffer != null) {
                this.hFile.write(blk.mappedBuffer.getPage(ctl.blkOffset), 0, this.pageSize);
            } else {
                this.hFile.write(blk.unmappedBuffer, 0, this.pageSize);
            }
            ctl.setDirty(false);
        }
        catch (IOException ex) {
            throw new DomainException("I/O error writing block", ex);
        }
    }

    public int restoreFile() throws DomainException {
        TBLSpace space = this.referSpace(16);
        TBLPage page = space.page;
        int offset = space.offset;
        if (offset == 0) {
            return 29;
        }
        if (page.mappedBuffer != null) {
            if (page.mappedBuffer.getByte(offset + 0) != 1) {
                return 29;
            }
            if (page.mappedBuffer.getByte(offset + 1) != 5) {
                return 39;
            }
            this.pageSize = TBLTable.getShort(page.mappedBuffer, offset + 2);
            this.rootOffset = (int)TBLTable.getLong(page.mappedBuffer, offset + 4);
            this.spcAvail = (int)TBLTable.getLong(page.mappedBuffer, offset + 8);
            this.spcLeft = TBLTable.getShort(page.mappedBuffer, offset + 12);
        } else {
            if (page.unmappedBuffer[offset + 0] != 1) {
                return 29;
            }
            if (page.unmappedBuffer[offset + 1] != 5) {
                return 39;
            }
            this.pageSize = TBLTable.getShort(page.unmappedBuffer, offset + 2);
            this.rootOffset = (int)TBLTable.getLong(page.unmappedBuffer, offset + 4);
            this.spcAvail = (int)TBLTable.getLong(page.unmappedBuffer, offset + 8);
            this.spcLeft = TBLTable.getShort(page.unmappedBuffer, offset + 12);
        }
        return 0;
    }

    public int restorePrototypes() throws DomainException {
        if (this.protos != null) {
            return 0;
        }
        TBLPage[] pages = new TBLPage[1];
        int rec = this.referSpace(16, pages);
        TBLPage recPage = pages[0];
        if (rec == 0) {
            return 29;
        }
        int num = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 14) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 14);
        if (num != 0) {
            int rc = 0;
            TBLTable table = this.masterNew(false, null);
            table.tblFlags |= 0x40;
            this.protos = table;
            TBLStruct[] tsArr = new TBLStruct[]{table.layout};
            rc = this.restoreStruct(table, null, num, 4, tsArr);
            table.layout = tsArr[0];
            if (rc != 0) {
                return rc;
            }
            rc = this.restoreLinks(table, table.layout);
            if (rc != 0) {
                return rc;
            }
        }
        return 0;
    }

    public TBLTable TblCopyTable(TBLStruct layout, TBLTable indices, int[] xlate) throws DomainException {
        if (layout == null || layout.type != 0) {
            throw new DomainException("ASSERT(layout && layout->type == TblDEFN_LAYOUT)");
        }
        TBLTable master = this.masterNew(true, xlate);
        TBLStruct newlay = master.layout;
        newlay.copy(layout);
        newlay.next = null;
        newlay.back = null;
        newlay.components = null;
        newlay.sname = null;
        newlay.table = master;
        newlay.visited = false;
        master.TblCopyStruct(layout.components, 2, master.layout);
        master.TblCopyStruct(layout.next, 1, master.layout);
        master.restoreLinks(master.layout);
        if (indices != null) {
            TBLTable ind = indices;
            while (ind != null) {
                TBLTable index = master.TblIndexNew(ind.layout.name);
                index.tblType = ind.tblType;
                index.TblCopyStruct(ind.layout.components, 2, index.layout);
                ind = ind.nextIndex;
            }
        } else {
            TBLStruct ixlay = layout.components;
            while (ixlay != null) {
                if (ixlay.type == 3) {
                    TBLTable index = master.TblIndexNew(ixlay.name);
                    index.tblType = ixlay.datatype != 0 ? 2 : 1;
                    index.TblCopyStruct(ixlay.components, 2, index.layout);
                }
                ixlay = ixlay.next;
            }
        }
        if (master.layout.precision != 0) {
            master.tblFlags |= 0x200;
        }
        master.TblCheckTable();
        return master;
    }

    public void TblCopyTablePrototypes(TBLFile outf) {
        if (this.protos != null && outf.protos == null) {
            TBLTable ind;
            outf.protos = ind = this.protos;
            outf.protos = ind = this.TblCopyTable(ind.layout, null, null);
        }
    }

    TBLTable masterNew(boolean makeroot, int[] xlate) {
        TBLTable master = new TBLTable();
        master.file = this;
        master.xlate = xlate;
        master.tblType = 0;
        master.tblFlags |= 8;
        master.curpar = master.layout = master.newTBLStruct(0, null);
        if (makeroot) {
            master.createRoot();
        }
        return master;
    }

    public int restoreTable(int off, TBLTable master, TBLTable[] ptable, boolean want_structs) throws DomainException {
        while (off != 0) {
            TBLPage frecPage;
            int frec;
            int fmtIndex;
            byte[] fmt;
            int need;
            int num;
            TBLTable table;
            TBLPage[] pages = new TBLPage[1];
            int rec = this.referSpace(off, pages);
            TBLPage recPage = pages[0];
            if (rec == 0) {
                return 29;
            }
            if (recPage.mappedBuffer != null) {
                if (recPage.mappedBuffer.getByte(rec + 0) != 3) {
                    return 29;
                }
                table = new TBLTable();
                table.file = this;
                if (ptable != null) {
                    ptable[0] = table;
                }
                table.address = off;
                table.rootOffset = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 1);
                table.tblType = recPage.mappedBuffer.getByte(rec + 5);
                table.leafRowLen = TBLTable.getShort(recPage.mappedBuffer, rec + 6);
                table.strOff = TBLTable.getShort(recPage.mappedBuffer, rec + 8);
                table.strCount = TBLTable.getShort(recPage.mappedBuffer, rec + 10);
                table.brRowLen = TBLTable.getShort(recPage.mappedBuffer, rec + 12);
                table.keyLen = TBLTable.getShort(recPage.mappedBuffer, rec + 14);
                table.tblFlags = TBLTable.getShort(recPage.mappedBuffer, rec + 16);
                table.strucId = TBLTable.getShort(recPage.mappedBuffer, rec + 18);
                table.recCount = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 20);
                table.numCols = TBLTable.getShort(recPage.mappedBuffer, rec + 36);
                table.formLen = TBLTable.getShort(recPage.mappedBuffer, rec + 38);
                table.delCount = (table.tblFlags & 0x1000) == 4096 ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 44) : 0;
                if (table.formLen != 0) {
                    num = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 40);
                    need = table.formLen;
                    fmt = new byte[need];
                    fmtIndex = 0;
                    table.colForm = fmt;
                    while (need != 0) {
                        if (num == 0) {
                            return 29;
                        }
                        frec = this.referSpace(num, pages);
                        frecPage = pages[0];
                        if (frec == 0) {
                            return 29;
                        }
                        num = (int)TBLTable.getLong(frecPage.mappedBuffer, frec);
                        if (need <= 1000) {
                            DomainByteArrayFileMap.arraycopy(frecPage.mappedBuffer, frec + 4, fmt, fmtIndex, need);
                            need = 0;
                            continue;
                        }
                        DomainByteArrayFileMap.arraycopy(frecPage.mappedBuffer, frec + 4, fmt, fmtIndex, 1000);
                        need -= 1000;
                        fmtIndex += 1000;
                    }
                }
            } else {
                if (recPage.unmappedBuffer[rec + 0] != 3) {
                    return 29;
                }
                table = new TBLTable();
                table.file = this;
                if (ptable != null) {
                    ptable[0] = table;
                }
                table.address = off;
                table.rootOffset = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 1);
                table.tblType = recPage.unmappedBuffer[rec + 5];
                table.leafRowLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 6);
                table.strOff = TBLTable.getShort(recPage.unmappedBuffer, rec + 8);
                table.strCount = TBLTable.getShort(recPage.unmappedBuffer, rec + 10);
                table.brRowLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 12);
                table.keyLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 14);
                table.tblFlags = TBLTable.getShort(recPage.unmappedBuffer, rec + 16);
                table.strucId = TBLTable.getShort(recPage.unmappedBuffer, rec + 18);
                table.recCount = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 20);
                table.numCols = TBLTable.getShort(recPage.unmappedBuffer, rec + 36);
                table.formLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 38);
                table.delCount = (table.tblFlags & 0x1000) == 4096 ? (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 44) : 0;
                if (table.formLen != 0) {
                    num = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 40);
                    need = table.formLen;
                    fmt = new byte[need];
                    fmtIndex = 0;
                    table.colForm = fmt;
                    while (need != 0) {
                        if (num == 0) {
                            return 29;
                        }
                        frec = this.referSpace(num, pages);
                        frecPage = pages[0];
                        if (frec == 0) {
                            return 29;
                        }
                        num = (int)TBLTable.getLong(frecPage.unmappedBuffer, frec);
                        if (need <= 1000) {
                            System.arraycopy(frecPage.unmappedBuffer, frec + 4, fmt, fmtIndex, need);
                            need = 0;
                            continue;
                        }
                        System.arraycopy(frecPage.unmappedBuffer, frec + 4, fmt, fmtIndex, 1000);
                        need -= 1000;
                        fmtIndex += 1000;
                    }
                }
            }
            if (master != null) {
                table.master = master;
                if (master.lastIndex != null) {
                    master.lastIndex.nextIndex = table;
                } else {
                    master.nextIndex = table;
                }
                master.lastIndex = table;
            } else {
                master = table;
            }
            if ((this.fileFlags & 2) != 0) {
                table.tblFlags |= 2;
            }
            if (want_structs && (num = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 24) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 24)) != 0) {
                TBLStruct[] tsArr = new TBLStruct[]{table.layout};
                int rc = this.restoreStruct(table, null, num, 4, tsArr);
                table.layout = tsArr[0];
                if (rc != 0) {
                    return rc;
                }
                rc = table.restoreLinks(table.layout);
                if (rc != 0) {
                    return rc;
                }
            }
            off = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 32) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 32);
            ptable = null;
        }
        return 0;
    }

    int restoreStruct(TBLTable table, TBLStruct parent, int off, int itype, TBLStruct[] pdef) throws DomainException {
        TBLStruct prevDef = null;
        while (off != 0) {
            int cname;
            int sname;
            int end;
            TBLPage[] pages = new TBLPage[1];
            int rec = this.referSpace(off, pages);
            TBLPage recPage = pages[0];
            if (rec == 0) {
                return 29;
            }
            if (recPage.mappedBuffer != null) {
                if (recPage.mappedBuffer.getByte(rec + 0) != itype) {
                    return 29;
                }
                if (recPage.mappedBuffer.getByte(rec + 13) == 5 && (recPage.mappedBuffer.getByte(rec + 21) == 11 || recPage.mappedBuffer.getByte(rec + 21) == 17)) {
                    end = rec + 37;
                    while (recPage.mappedBuffer.getByte(end) != 0) {
                        ++end;
                    }
                    sname = rec + 37;
                    cname = sname + EcUtil.strlen(recPage.mappedBuffer, sname) + 1;
                } else {
                    sname = 0;
                    cname = rec + 37;
                }
            } else {
                if (recPage.unmappedBuffer[rec + 0] != itype) {
                    return 29;
                }
                if (recPage.unmappedBuffer[rec + 13] == 5 && (recPage.unmappedBuffer[rec + 21] == 11 || recPage.unmappedBuffer[rec + 21] == 17)) {
                    end = rec + 37;
                    while (recPage.unmappedBuffer[end] != 0) {
                        ++end;
                    }
                    sname = rec + 37;
                    cname = sname + EcUtil.strlen(recPage.unmappedBuffer, sname) + 1;
                } else {
                    sname = 0;
                    cname = rec + 37;
                }
            }
            TBLStruct def = new TBLStruct();
            if (pdef != null) {
                pdef[0] = def;
            } else if (prevDef != null) {
                prevDef.next = def;
            }
            end = cname;
            if (recPage.mappedBuffer != null) {
                while (recPage.mappedBuffer.getByte(end) != 0) {
                    ++end;
                }
                def.name = new DomainString(recPage.mappedBuffer, cname, end - cname);
                def.back = parent;
                def.table = table;
                def.type = recPage.mappedBuffer.getByte(rec + 13);
                def.elements = TBLTable.getShort(recPage.mappedBuffer, rec + 14);
                def.offset = TBLTable.getShort(recPage.mappedBuffer, rec + 16);
                def.length = TBLTable.getShort(recPage.mappedBuffer, rec + 18);
                def.bitmask = recPage.mappedBuffer.getByte(rec + 20);
                def.datatype = recPage.mappedBuffer.getByte(rec + 21);
                def.strix = TBLTable.getShort(recPage.mappedBuffer, rec + 22);
                def.numstr = TBLTable.getShort(recPage.mappedBuffer, rec + 24);
                def.coloff = TBLTable.getShort(recPage.mappedBuffer, rec + 26);
                def.numcol = TBLTable.getShort(recPage.mappedBuffer, rec + 28);
                def.precision = recPage.mappedBuffer.getByte(rec + 30);
                def.srcOffset = TBLTable.getShort(recPage.mappedBuffer, rec + 31);
                def.srcString = TBLTable.getShort(recPage.mappedBuffer, rec + 33);
                def.srcColumn = TBLTable.getShort(recPage.mappedBuffer, rec + 35);
            } else {
                while (recPage.unmappedBuffer[end] != 0) {
                    ++end;
                }
                def.name = new DomainString(recPage.unmappedBuffer, cname, end - cname);
                def.back = parent;
                def.table = table;
                def.type = recPage.unmappedBuffer[rec + 13];
                def.elements = TBLTable.getShort(recPage.unmappedBuffer, rec + 14);
                def.offset = TBLTable.getShort(recPage.unmappedBuffer, rec + 16);
                def.length = TBLTable.getShort(recPage.unmappedBuffer, rec + 18);
                def.bitmask = recPage.unmappedBuffer[rec + 20];
                def.datatype = recPage.unmappedBuffer[rec + 21];
                def.strix = TBLTable.getShort(recPage.unmappedBuffer, rec + 22);
                def.numstr = TBLTable.getShort(recPage.unmappedBuffer, rec + 24);
                def.coloff = TBLTable.getShort(recPage.unmappedBuffer, rec + 26);
                def.numcol = TBLTable.getShort(recPage.unmappedBuffer, rec + 28);
                def.precision = recPage.unmappedBuffer[rec + 30];
                def.srcOffset = TBLTable.getShort(recPage.unmappedBuffer, rec + 31);
                def.srcString = TBLTable.getShort(recPage.unmappedBuffer, rec + 33);
                def.srcColumn = TBLTable.getShort(recPage.unmappedBuffer, rec + 35);
            }
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int num = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 9) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 9);
                    if (num == 0) break;
                    TBLStruct[] tsArr = new TBLStruct[]{def.components};
                    int rc = this.restoreStruct(table, def, num, 7, tsArr);
                    def.components = tsArr[0];
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    int num = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 9) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 9);
                    if (num == 0) break;
                    TBLStruct[] tsArr = new TBLStruct[]{def.components};
                    int rc = this.restoreStruct(table, def, num, 6, tsArr);
                    def.components = tsArr[0];
                    if (rc == 0) break;
                    return rc;
                }
                case 5: {
                    if (def.datatype != 11 && def.datatype != 17) break;
                    if (recPage.mappedBuffer != null) {
                        int sLen = EcUtil.strlen(recPage.mappedBuffer, sname);
                        def.sname = new DomainString(recPage.mappedBuffer, sname, sLen);
                        break;
                    }
                    int sLen = EcUtil.strlen(recPage.unmappedBuffer, sname);
                    def.sname = new DomainString(recPage.unmappedBuffer, sname, sLen);
                    break;
                }
            }
            off = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 1) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 1);
            if (itype == 4) {
                itype = 5;
            }
            pdef = null;
            prevDef = def;
        }
        return 0;
    }

    int restoreLinks(TBLTable table, TBLStruct def) {
        while (def != null) {
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int rc = this.restoreLinks(table, def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    int rc = this.restoreLinks(table, def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 5: {
                    if (def.datatype != 11 && def.datatype != 17) break;
                    def.components = table.layout.find(def.sname);
                    if (def.components == null && table.file.protos != null && table != table.file.protos) {
                        def.components = table.file.protos.layout.find(def.sname);
                    }
                    if (def.components == null) {
                        return 29;
                    }
                    def.sname = null;
                    break;
                }
            }
            def = def.next;
        }
        return 0;
    }

    public int compactLink(LEHandle le) {
        return this.compactInternal(le, 0, null, false);
    }

    private int compactInternal(LEHandle le, int codePage, int[] xlate, boolean wantConsolid) {
        int rc;
        if ((this.fileFlags & 2) == 0 && (rc = this.save()) != 0) {
            return rc;
        }
        TBLCompaction tc = new TBLCompaction(le, codePage, xlate, wantConsolid, this);
        rc = this.restorePrototypes();
        if (rc != 0) {
            return rc;
        }
        if (this.protos != null) {
            int wrote;
            tc.index = 0;
            rc = tc.compactStruct(4, this.protos.layout);
            if (rc != 0) {
                return rc;
            }
            String protoStr = "_prototypes_%R";
            System.arraycopy(protoStr.getBytes(), 0, tc.buffer, tc.index + 1, protoStr.length());
            if (xlate != null) {
                EcUtil.convertCharSet(tc.buffer, tc.index + 1, xlate);
            }
            if ((wrote = le.metaLinkWrite(tc.buffer, tc.index + 1, tc.buffer, 0, tc.index, codePage | 0x10 | 0x400 | 1 | 0x800)) == 0) {
                return 33;
            }
        }
        rc = tc.th.firstSection();
        while (rc == 0) {
            rc = tc.compactSection(true);
            if (rc != 0) {
                return rc;
            }
            rc = tc.th.nextSection();
        }
        return 0;
    }

    int TblUnCompactTableStart(TBLTable[] master, int pages) throws DomainException {
        master[0] = new TBLTable();
        master[0].file = this;
        int baseOffset = 0;
        for (int pnum = 0; pnum < pages; ++pnum) {
            TBLPage page = this.allocPage();
            int roff = this.getPageOffset(page);
            if (baseOffset == 0) {
                baseOffset = roff;
            }
            if (roff == baseOffset + pnum * this.pageSize) continue;
            throw new DomainException("ASSERT (roff == baseOffset + pnum*tblfile->pageSize)");
        }
        return baseOffset;
    }

    int TblUnCompactTableDefinition(TBLTable master, TBLTable table, DomainByteArrayFileMap mappedBuffer, byte[] unmappedBuffer, int offset, int baseOffset, boolean IsIndex) {
        int rc;
        if (IsIndex) {
            table = new TBLTable();
            table.file = this;
            table.master = master;
            if (master.lastIndex != null) {
                master.lastIndex.nextIndex = table;
            } else {
                master.nextIndex = table;
            }
            master.lastIndex = table;
        }
        DomainEcNumber ptr = mappedBuffer != null ? new DomainEcNumber(mappedBuffer, offset) : new DomainEcNumber(unmappedBuffer, offset);
        int pnum = ptr.getEcNumber();
        table.rootOffset = baseOffset + (pnum - 1) * this.pageSize;
        table.tblType = ptr.getEcNumber();
        table.leafRowLen = ptr.getEcNumber();
        table.strOff = ptr.getEcNumber();
        table.strCount = ptr.getEcNumber();
        table.brRowLen = ptr.getEcNumber();
        table.keyLen = ptr.getEcNumber();
        table.tblFlags = ptr.getEcNumber() | 0x10;
        table.strucId = ptr.getEcNumber();
        table.recCount = ptr.getEcNumber();
        table.numCols = ptr.getEcNumber();
        table.formLen = ptr.getEcNumber();
        table.delCount = (table.tblFlags & 0x1000) == 4096 ? ptr.getEcNumber() : 0;
        if (table.formLen != 0) {
            table.colForm = new byte[table.formLen];
            if (ptr.getMappedData() != null) {
                DomainByteArrayFileMap.arraycopy(ptr.getMappedData(), ptr.getOffset(), table.colForm, 0, table.formLen);
            } else {
                System.arraycopy(ptr.getUnmappedData(), ptr.getOffset(), table.colForm, 0, table.formLen);
            }
            ptr.incOffset(table.formLen);
        }
        if ((rc = table.unCompactStruct(ptr, 4, table, null)) != 0) {
            return rc;
        }
        rc = table.restoreLinks(table.layout);
        return rc;
    }

    int TblUnCompactTablePage(int pagenum, int baseOffset, DomainByteArrayFileMap mappedBuffer, byte[] unmappedBuffer, int offset) {
        int rec;
        int pgsize = this.pageSize;
        int roff = baseOffset + (pagenum - 1) * pgsize;
        TBLPage page = this.absolutePage(roff);
        DomainEcNumber ptr = mappedBuffer != null ? new DomainEcNumber(mappedBuffer, offset) : new DomainEcNumber(unmappedBuffer, offset);
        int brow = ptr.getEcNumber();
        if (ptr.getMappedData() != null) {
            page.changeHeader(ptr.getMappedData(), ptr.getOffset());
        } else {
            page.changeHeader(ptr.getUnmappedData(), ptr.getOffset());
        }
        ptr.incOffset(16);
        page.setPageLen(pgsize);
        int rused = page.getPageRowData();
        int sused = page.getPageStrings();
        int middle = pgsize - 16 - rused - sused;
        if (middle < 0) {
            return 34;
        }
        if (ptr.getMappedData() != null) {
            page.setBodyBytes(ptr.getMappedData(), ptr.getOffset(), rused);
        } else {
            page.setBodyBytes(ptr.getUnmappedData(), ptr.getOffset(), rused);
        }
        ptr.incOffset(rused);
        if (page.isBranch()) {
            pagenum = page.getPageLower();
            page.setLower(baseOffset + (pagenum - 1) * pgsize);
            rec = 0;
            for (int nrec = page.getPageRecords(); nrec > 0; --nrec) {
                pagenum = page.getBodyLong(rec + brow - 4);
                page.setBodyLong(rec + brow - 4, baseOffset + (pagenum - 1) * pgsize);
                rec += brow;
            }
        } else {
            pagenum = page.getPageLower();
            if (pagenum != 0) {
                page.setLower(baseOffset + (pagenum - 1) * pgsize);
            }
            if ((pagenum = page.getPageForward()) != 0) {
                page.setForward(baseOffset + (pagenum - 1) * pgsize);
            }
        }
        rec = rused;
        if (middle != 0) {
            page.zeroBodyMemory(rec, middle);
            rec += middle;
        }
        if (sused > 0) {
            if (ptr.getMappedData() != null) {
                page.setBodyBytes(ptr.getMappedData(), ptr.getOffset(), rec, sused);
            } else {
                page.setBodyBytes(ptr.getUnmappedData(), ptr.getOffset(), rec, sused);
            }
            ptr.incOffset(sused);
        }
        page.modifiedPage();
        return 0;
    }

    public int getFileFlags() {
        return this.fileFlags;
    }

    public int flushTbl() {
        TBLPage bb = this.lruBlk;
        while (bb != null) {
            TBLPageCtl bbpc = bb.getControlPart();
            if (bbpc.isDirty()) {
                this.writeToDisk(bb);
            }
            bb = bbpc.mruPtr;
        }
        this.flush();
        return 0;
    }
}

