/*
 * Decompiled with CFR 0.152.
 */
package com.modal.claim;

import com.constants.batch.BatchClaimInput_EN;
import com.constants.batch.BatchProcedureInput_EN;
import com.constants.batch.BatchProcedureOutput_EN;
import com.constants.batch.ClaimOutput_EN;
import com.modal.Diagnosis;
import com.modal.Edit;
import com.modal.Procedure;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import java.io.BufferedWriter;
import java.io.IOException;

public class Claim {
    private GrouperInput grouperInput;
    private GrouperOutput grouperOutput;

    public Claim() {
        this.grouperInput = new GrouperInput();
        this.grouperOutput = new GrouperOutput();
        for (int i2 = 0; i2 < 450; ++i2) {
            this.grouperInput.getProcedures().add((Object)new Procedure());
        }
    }

    public void parseBatchAndSet(String lineToParse, int linePointer) {
        for (BatchClaimInput_EN v : BatchClaimInput_EN.values()) {
            if (!v.getLine().substring(0, 1).equals(lineToParse.substring(0, 1))) continue;
            v.set(this, lineToParse);
        }
        if (lineToParse.startsWith("L")) {
            block1: for (Procedure p : this.grouperInput.getProcedures()) {
                for (BatchProcedureInput_EN v : BatchProcedureInput_EN.values()) {
                    if (this.grouperInput.getProcedures().indexOf((Object)p) != linePointer) continue block1;
                    if (!lineToParse.startsWith(v.getLine())) continue;
                    v.set(p, lineToParse);
                }
            }
        }
    }

    public Claim(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
    }

    public GrouperInput getGrouperInput() {
        return this.grouperInput;
    }

    public GrouperOutput getGrouperOutput() {
        return this.grouperOutput;
    }

    public void setGrouperOutput(GrouperOutput grouperOutput) {
        this.grouperOutput = grouperOutput;
    }

    public void writeClaimToFile(BufferedWriter writer) throws IOException {
        int _MAX_LINE_LEN_ = 300;
        boolean _REC_ID_LEN_ = true;
        int _LINE_ITEM_ID_ = 3;
        int lineCount = 0;
        String _BLANK_STRING_ = new String(new char[299 - this.getGrouperInput().getClaimID().length()]).replace('\u0000', ' ') + "\n";
        String cRecord = "C" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String dRecord = "D" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String eRecord = "E" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String fRecord = "F" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String mRecord = "M" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String nRecord = "N" + this.getGrouperInput().getClaimID() + _BLANK_STRING_;
        String[] claimLevelInputs = new String[]{cRecord, dRecord, eRecord, fRecord};
        String[] claimLevelOutputs = new String[]{mRecord, nRecord};
        for (String lineToParse : claimLevelInputs) {
            for (BatchClaimInput_EN batchClaimInput_EN : BatchClaimInput_EN.values()) {
                if (!batchClaimInput_EN.getLine().substring(0, 1).equals(lineToParse.substring(0, 1))) continue;
                lineToParse = batchClaimInput_EN.print(this, lineToParse);
            }
            if (!(lineToParse.startsWith("C") && this.grouperInput.isHasCRecord() || lineToParse.startsWith("D") && this.grouperInput.isHasDRecord() || lineToParse.startsWith("E") && this.grouperInput.isHasERecord()) && (!lineToParse.startsWith("F") || !this.grouperInput.isHasFRecord())) continue;
            writer.write(lineToParse);
        }
        String _BLANK_LINE = new String(new char[300 - this.getGrouperInput().getClaimID().length() - 1 - 3]).replace('\u0000', ' ') + "\n";
        for (Procedure p : this.grouperInput.getProcedures()) {
            String lRecord = "L" + this.getGrouperInput().getClaimID() + String.format("%3s", this.grouperInput.getProcedures().indexOf((Object)p) + 1).replace(" ", "0") + _BLANK_LINE;
            for (Enum enum_ : BatchProcedureInput_EN.values()) {
                lRecord = enum_.print(p, lRecord);
            }
            if (lRecord.substring(22).trim().isEmpty()) break;
            writer.write(lRecord);
            ++lineCount;
        }
        for (String lineToParse : claimLevelOutputs) {
            for (ClaimOutput_EN en : ClaimOutput_EN.values()) {
                if (!en.getLine().equals(lineToParse.substring(0, 1))) continue;
                lineToParse = en.print(this, lineToParse);
            }
            writer.write(lineToParse);
        }
        int _O_RECORD_SDX_MAX_ = 5;
        int _P_RECORD_SDX_MAX_ = 14;
        int _Q_RECORD_SDX_MAX_ = 24;
        boolean printP = false;
        boolean printQ = false;
        boolean pdxPresent = false;
        StringBuilder stringBuilder = new StringBuilder("O").append(this.getGrouperInput().getClaimID());
        StringBuilder pRecSB = new StringBuilder("P").append(this.getGrouperInput().getClaimID());
        StringBuilder qRecSB = new StringBuilder("Q").append(this.getGrouperInput().getClaimID());
        for (Diagnosis d : this.grouperInput.getRvdxList()) {
            for (Object edit : d.getEdits()) {
                stringBuilder.append(((Edit)edit).getEdit());
            }
        }
        for (Diagnosis d : this.grouperInput.getPdxList()) {
            for (Object edit : d.getEdits()) {
                stringBuilder.append(((Edit)edit).getEdit());
            }
            pdxPresent = pdxPresent || !d.getCode().trim().isEmpty();
        }
        int count = 0;
        for (Diagnosis d : this.grouperInput.getSdxList()) {
            if (d.getCode().trim().isEmpty()) continue;
            for (Edit edit : d.getEdits()) {
                if (count < 5) {
                    stringBuilder.append(edit.getEdit());
                    continue;
                }
                if (count < 14 && pdxPresent) {
                    printP = printP || !d.getCode().trim().isEmpty();
                    pRecSB.append(edit.getEdit());
                    continue;
                }
                if (count >= 24 || !pdxPresent) continue;
                printQ = printQ || !d.getCode().trim().isEmpty();
                qRecSB.append(edit.getEdit());
            }
            ++count;
        }
        writer.write(String.format("%-300s\n", stringBuilder.toString()));
        if (printP) {
            writer.write(String.format("%-300s\n", pRecSB.toString()));
        }
        if (printQ) {
            writer.write(String.format("%-300s\n", qRecSB.toString()));
        }
        for (Procedure p : this.grouperOutput.getProcedureArrayList()) {
            String rRecord = "R" + this.getGrouperInput().getClaimID() + String.format("%3s", this.grouperInput.getProcedures().indexOf((Object)p) + 1).replace(" ", "0") + _BLANK_LINE;
            String sRecord = "S" + this.getGrouperInput().getClaimID() + String.format("%3s", this.grouperInput.getProcedures().indexOf((Object)p) + 1).replace(" ", "0") + _BLANK_LINE;
            if (!(p.getCode().trim().isEmpty() && p.getRevenueCode().trim().isEmpty() && p.getServiceDate().trim().isEmpty())) {
                for (BatchProcedureOutput_EN en : BatchProcedureOutput_EN.values()) {
                    if (en.getLine().equals(rRecord.substring(0, 1))) {
                        rRecord = en.print(p, rRecord);
                    }
                    if (!en.getLine().equals(sRecord.substring(0, 1))) continue;
                    sRecord = en.print(p, sRecord);
                }
            }
            if (this.grouperOutput.getProcedureArrayList().indexOf(p) > lineCount - 1) break;
            writer.write(rRecord);
            writer.write(sRecord);
        }
        writer.flush();
    }
}

