/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class ControlUtils {
    public static void disableAndReset(boolean isDisable, Control ... controls) {
        for (Control c : controls) {
            c.setDisable(isDisable);
            if (!isDisable) continue;
            if (c instanceof ComboBox) {
                ((ComboBox)c).getSelectionModel().select(0);
                continue;
            }
            if (!(c instanceof TextField)) continue;
            ((TextField)c).setText("");
        }
    }

    public static void setText(String s, Control ... controls) {
        for (Control c : controls) {
            if (c instanceof Label) {
                ((Label)c).setText(s);
                continue;
            }
            if (!(c instanceof TextField)) continue;
            ((TextField)c).setText(s);
        }
    }

    public static void resetControl(Control ... controls) {
        for (Control c : controls) {
            if (c instanceof Label) {
                ((Label)c).setText("");
                continue;
            }
            if (c instanceof TextField) {
                ((TextField)c).setText("");
                continue;
            }
            if (c instanceof DatePicker) {
                ((DatePicker)c).setValue(null);
                continue;
            }
            if (c instanceof Button) {
                c.setDisable(false);
                continue;
            }
            if (!(c instanceof ComboBox)) continue;
            ((ComboBox)c).getSelectionModel().select(0);
        }
    }
}

