/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.constants.code.ProcedureColumn_EN;
import com.modal.Diagnosis;
import com.modal.Procedure;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;

public class TableUtils {
    public static void initDxTable(TableView<Diagnosis> tableView, ObservableList<Diagnosis> data) {
        data.clear();
        TableColumn codeColumns = new TableColumn("Code");
        codeColumns.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        codeColumns.setCellFactory(TextFieldTableCell.forTableColumn());
        codeColumns.prefWidthProperty().bind((ObservableValue)tableView.widthProperty().multiply(0.2));
        codeColumns.setSortable(false);
        TableColumn descriptionColumn = new TableColumn("Description");
        descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        descriptionColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        descriptionColumn.prefWidthProperty().bind((ObservableValue)tableView.widthProperty().multiply(0.8));
        descriptionColumn.setSortable(false);
        tableView.getColumns().clear();
        tableView.getColumns().addAll((Object[])new TableColumn[]{codeColumns, descriptionColumn});
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        tableView.setItems(data);
    }

    private static TableColumn<Procedure, String> createColumn(String header, String property) {
        TableColumn c = new TableColumn(header);
        c.setCellValueFactory((Callback)new PropertyValueFactory(property));
        c.setCellFactory(TextFieldTableCell.forTableColumn());
        return c;
    }

    public static void initProcedureTable(TableView<Procedure> tableView, ObservableList<Procedure> data) {
        data.clear();
        tableView.getColumns().clear();
        ArrayList<TableColumn<Procedure, String>> columns = new ArrayList<TableColumn<Procedure, String>>();
        for (ProcedureColumn_EN pc : ProcedureColumn_EN.values()) {
            TableColumn<Procedure, String> c = TableUtils.createColumn(pc.toString(), pc.property);
            switch (pc) {
                case CODE: {
                    c.setMinWidth(25.0);
                    c.setEditable(false);
                    break;
                }
                case MOD1: {
                    c.setEditable(false);
                    c.setPrefWidth(20.0);
                    break;
                }
                case MOD2: {
                    c.setEditable(false);
                    c.setPrefWidth(20.0);
                    break;
                }
                case MOD3: {
                    c.setEditable(false);
                    c.setPrefWidth(20.0);
                    break;
                }
                case MOD4: {
                    c.setEditable(false);
                    c.setPrefWidth(20.0);
                    break;
                }
                case MOD5: {
                    c.setEditable(false);
                    c.setPrefWidth(20.0);
                    break;
                }
                case REV: {
                    c.setEditable(false);
                    c.setMinWidth(20.0);
                    break;
                }
                case UNITS: {
                    c.setEditable(false);
                    c.setMinWidth(55.0);
                    break;
                }
                case CHG: {
                    c.setEditable(false);
                    c.setMinWidth(55.0);
                    break;
                }
                case DATE: {
                    c.setEditable(false);
                    c.setMinWidth(35.0);
                    break;
                }
                case AF: {
                    c.setEditable(false);
                    c.setMinWidth(15.0);
                    break;
                }
                case EDIT1: {
                    c.setEditable(false);
                    c.setPrefWidth(15.0);
                    break;
                }
                case EDIT2: {
                    c.setEditable(false);
                    c.setPrefWidth(15.0);
                    break;
                }
                case EDIT3: {
                    c.setEditable(false);
                    c.setPrefWidth(15.0);
                    break;
                }
                case EDIT4: {
                    c.setEditable(false);
                    c.setPrefWidth(15.0);
                    break;
                }
                case APC: {
                    c.setEditable(false);
                    c.setMinWidth(25.0);
                    break;
                }
                case SI: {
                    c.setEditable(false);
                    c.setMinWidth(5.0);
                    break;
                }
                case PI: {
                    c.setEditable(false);
                    c.setMinWidth(5.0);
                    break;
                }
                case DF: {
                    c.setEditable(false);
                    c.setMinWidth(5.0);
                    break;
                }
                case DRF: {
                    c.setEditable(false);
                    c.setMinWidth(15.0);
                    break;
                }
                case PKG: {
                    c.setEditable(false);
                    c.setMinWidth(15.0);
                    break;
                }
                case PAF: {
                    c.setEditable(false);
                    c.setMinWidth(15.0);
                    break;
                }
                case PMF: {
                    c.setEditable(false);
                    c.setMinWidth(15.0);
                    break;
                }
                default: {
                    System.exit(-1);
                }
            }
            columns.add(c);
        }
        tableView.getColumns().addAll((Object[])columns.toArray(new TableColumn[0]));
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableView.setItems(data);
    }

    public static void clearTable(TableView t) {
        t.getItems().clear();
        t.getColumns().clear();
    }
}

