/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;

public class TextFieldListener
implements ChangeListener<Boolean> {
    private final TextField textField;
    private final int length;
    private final String padChar;
    private final JUSTIFICATION_EN pad;

    public TextFieldListener(TextField textField, int length, String padChar, JUSTIFICATION_EN pad) {
        this.textField = textField;
        this.length = length;
        this.padChar = padChar;
        this.pad = pad;
    }

    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            if (this.pad == JUSTIFICATION_EN.LEFT) {
                if (!this.textField.getText().trim().equals("")) {
                    this.textField.setText(this.padRight());
                }
            } else if (this.pad == JUSTIFICATION_EN.RIGHT) {
                if (!this.textField.getText().trim().equals("")) {
                    this.textField.setText(this.padLeft());
                }
            } else if (this.pad == JUSTIFICATION_EN.CURRENCY && !this.textField.getText().trim().equals("")) {
                this.textField.setText(this.currencyPad());
            }
        }
        if (this.textField.getParent() != null && this.textField.getParent().getAccessibleText() != null && this.textField.getParent().getAccessibleText().contains(" of ")) {
            this.textField.setAccessibleText(this.textField.getParent().getAccessibleText() + " : " + this.textField.getText());
        } else if (this.textField.getAccessibleText() != null && this.textField.getAccessibleText().contains(" of ")) {
            this.textField.setAccessibleText(this.textField.getAccessibleText().replace(this.textField.getText(), "") + " " + this.textField.getText());
        } else {
            this.textField.setAccessibleText(this.textField.getText());
        }
    }

    private String padLeft() {
        return String.format("%" + this.length + "s", this.textField.getText()).replace(" ", this.padChar);
    }

    private String padRight() {
        return String.format("%-" + this.length + "s", this.textField.getText()).replace(" ", this.padChar);
    }

    private String currencyPad() {
        if (!this.textField.getText().trim().isEmpty()) {
            return String.format("%" + this.length + "s", this.textField.getText()).replace(" ", this.padChar);
        }
        return this.padLeft();
    }

    public static enum JUSTIFICATION_EN {
        LEFT,
        RIGHT,
        CURRENCY,
        NONE;

    }
}

