/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.EXPERIMENTAL, since="5.4")
public interface DisplayNameGenerator {
    public String generateDisplayNameForClass(Class<?> var1);

    public String generateDisplayNameForNestedClass(Class<?> var1);

    public String generateDisplayNameForMethod(Class<?> var1, Method var2);

    public static String parameterTypesAsString(Method method) {
        Preconditions.notNull(method, "Method must not be null");
        return '(' + ClassUtils.nullSafeToString(Class::getSimpleName, method.getParameterTypes()) + ')';
    }

    public static class ReplaceUnderscores
    extends Simple {
        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForClass(testClass));
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForNestedClass(nestedClass));
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForMethod(testClass, testMethod));
        }

        private static String replaceUnderscores(String name) {
            return name.replace('_', ' ');
        }
    }

    public static class Simple
    extends Standard {
        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            String displayName = testMethod.getName();
            if (Simple.hasParameters(testMethod)) {
                displayName = displayName + ' ' + DisplayNameGenerator.parameterTypesAsString(testMethod);
            }
            return displayName;
        }

        private static boolean hasParameters(Method method) {
            return method.getParameterCount() > 0;
        }
    }

    public static class Standard
    implements DisplayNameGenerator {
        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            String name = testClass.getName();
            int lastDot = name.lastIndexOf(46);
            return name.substring(lastDot + 1);
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return nestedClass.getSimpleName();
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return testMethod.getName() + DisplayNameGenerator.parameterTypesAsString(testMethod);
        }
    }
}

