/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DomainClassBrowser {
    private ClassFilter classFilter = new ClassFilter();
    private PkgFilter pkgFilter = new PkgFilter();

    public int getIndexInClasspath(String classpath, String className) {
        int pos = 0;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File file = new File(path);
            if (this.containsClass("", file, className)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsClass(String root, File file, String className) {
        if (file.isDirectory()) {
            Object[] files = file.list(this.classFilter);
            Arrays.sort(files);
            int pos = Arrays.binarySearch(files, className);
            if (pos >= 0) {
                return true;
            }
            File[] dirs = file.listFiles(this.pkgFilter);
            for (int i = 0; i < dirs.length; ++i) {
                boolean found = this.containsClass(root + dirs[i].getName() + ".", dirs[i], className);
                if (!found) continue;
                return found;
            }
            return false;
        } else {
            if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) return false;
            try {
                Object[] files = DomainClassBrowser.getClasses(file);
                Arrays.sort(files);
                int pos = Arrays.binarySearch(files, className + ".class");
                if (pos < 0) return false;
                return true;
            }
            catch (ZipException zipEx) {
                System.err.println(zipEx.getMessage());
                return false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public String getComponentName(String[] components, String classpath, String methodName, String paramSig) {
        return this.getComponentName(components, classpath, methodName, paramSig, new int[]{-1});
    }

    public String getComponentName(String[] components, String classpath, String methodName, String paramSig, int[] pos) {
        Class[] paramTypes = DomainClassBrowser.getParamTypes(paramSig);
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                try {
                    Class<?> cls = Class.forName(components[i]);
                    Method method = cls.getMethod(methodName, paramTypes);
                    pos[0] = i;
                    return components[i];
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        return this.getClassName(classpath, methodName, paramTypes, pos);
    }

    private String getClassName(String classpath, String methodName, Class[] paramTypes, int[] pos) {
        String compName = null;
        int count = 0;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File file = new File(path);
            compName = this.getClassName("", file, methodName, paramTypes);
            if (compName != null) {
                pos[0] = count;
                break;
            }
            ++count;
        }
        return compName;
    }

    private String getClassName(String root, File file, String methodName, Class[] paramTypes) {
        block7: {
            block6: {
                if (!file.isDirectory()) break block6;
                String[] files = file.list(this.classFilter);
                String compName = DomainClassBrowser.inspectFiles(root, files, methodName, paramTypes);
                if (compName != null) {
                    return compName;
                }
                File[] dirs = file.listFiles(this.pkgFilter);
                for (int i = 0; i < dirs.length; ++i) {
                    compName = this.getClassName(root + dirs[i].getName() + ".", dirs[i], methodName, paramTypes);
                    if (compName == null) continue;
                    return compName;
                }
                break block7;
            }
            if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) break block7;
            try {
                String[] files = DomainClassBrowser.getClasses(file);
                for (int i = 0; i < files.length; ++i) {
                    String name;
                    if (!files[i].endsWith(".class") || !DomainClassBrowser.containsMethod(name = files[i].substring(0, files[i].lastIndexOf(".class")), methodName, paramTypes)) continue;
                    return name;
                }
            }
            catch (ZipException zipEx) {
                System.err.println(zipEx.getMessage());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static String inspectFiles(String parent, String[] files, String methodName, Class[] paramTypes) {
        for (int i = 0; i < files.length; ++i) {
            String name = parent + files[i].substring(0, files[i].lastIndexOf(".class"));
            if (!DomainClassBrowser.containsMethod(name, methodName, paramTypes)) continue;
            return name;
        }
        return null;
    }

    private static Class[] getParamTypes(String paramSig) {
        ArrayList paramList = new ArrayList();
        StringTokenizer st = new StringTokenizer(paramSig, ";");
        while (st.hasMoreTokens()) {
            try {
                String token = st.nextToken();
                int index = 0;
                int arrayDim = 0;
                while ((index = token.indexOf("[]", index)) > 0) {
                    ++arrayDim;
                    ++index;
                }
                if (arrayDim > 0) {
                    StringBuffer buffer = new StringBuffer();
                    while (arrayDim-- > 0) {
                        buffer.append("[");
                    }
                    buffer.append("L");
                    buffer.append(token.substring(0, token.indexOf("[]")));
                    buffer.append(";");
                    token = buffer.toString();
                }
                paramList.add(Class.forName(token));
            }
            catch (ClassNotFoundException token) {}
        }
        Class[] paramTypes = new Class[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            paramTypes[i] = (Class)paramList.get(i);
        }
        return paramTypes;
    }

    private static String[] getClasses(File archiveName) throws IOException {
        ZipFile zf;
        Vector<String> vName = new Vector<String>();
        Vector vModified = new Vector();
        Vector vSize = new Vector();
        Vector vPacked = new Vector();
        Vector vArchive = new Vector();
        Vector vPath = new Vector();
        if (archiveName == null) {
            return null;
        }
        File file = archiveName;
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException zipEx) {
            throw new ZipException(zipEx.getMessage() + " (Filename: '" + file.getPath() + File.separator + file.getName() + "')");
        }
        ZipEntry ze = null;
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            String str = ((Object)e.nextElement()).toString();
            File f = new File(str);
            ze = zf.getEntry(str);
            if (ze.isDirectory()) continue;
            String parent = f.getParent() != null ? f.getParent() + "." : "";
            vName.addElement(parent.replace(File.separatorChar, '.') + f.getName());
        }
        String[] classRecs = new String[vName.size()];
        for (int i = 0; i < vName.size(); ++i) {
            classRecs[i] = (String)vName.elementAt(i);
        }
        return classRecs;
    }

    private static boolean containsMethod(String name, String methodName, Class[] paramTypes) {
        boolean found = false;
        try {
            Class<?> cls = Class.forName(name);
            Method method = cls.getMethod(methodName, paramTypes);
            found = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return found;
    }

    public String getConstructorParamTypes(String className) {
        try {
            boolean found = true;
            Class<?> cls = Class.forName(className);
            Class<?> compClass = Class.forName("com.mmmhis.domain.DomainComponent");
            Constructor<?> c = null;
            Constructor<?>[] ctrs = cls.getConstructors();
            for (int i = 0; i < ctrs.length; ++i) {
                if (c != null && ctrs[i].getParameterTypes().length <= c.getParameterTypes().length) continue;
                found = true;
                for (int j = 1; j < ctrs[i].getParameterTypes().length; ++j) {
                    if (!compClass.isAssignableFrom(ctrs[i].getParameterTypes()[j])) {
                        found = false;
                        break;
                    }
                    found = true;
                }
                if (!found) continue;
                c = ctrs[i];
            }
            String name = c.toString();
            return name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static class PkgFilter
    implements FilenameFilter {
        PkgFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            String dirName = dir + File.separator + name;
            return new File(dirName).isDirectory();
        }
    }

    static class ClassFilter
    implements FilenameFilter {
        ClassFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".class");
        }
    }
}

