/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainExtDate;
import com.mmmhis.domain.DomainFloat;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.ec.EcDate;

public final class DomainDate
extends DomainVariable {
    private EcDate GDate;

    public EcDate getGDate() {
        return this.GDate;
    }

    public void setGDate(EcDate gdate) {
        this.GDate = gdate;
    }

    public DomainDate() {
        this.GDate = new EcDate();
    }

    public DomainDate(long date) {
        this.GDate = new EcDate(date);
    }

    public DomainDate(DomainDate date) {
        this.GDate = new EcDate(date.getGDate());
    }

    public DomainDate(double date) {
        this.GDate = new EcDate(date);
    }

    public DomainDate(DomainExtDate date) {
        this.GDate = new EcDate((long)date.getValue());
    }

    public DomainDate(EcDate date) {
        this.GDate = new EcDate(date);
    }

    public DomainDate(DomainEnvironment _env, String text) {
        this.GDate = new EcDate();
        this.setValue(_env, text);
    }

    public DomainDate(DomainDate[] a, int i) {
        this.GDate = new EcDate();
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainDate(int aYear, int aMonth, int aDay, int aHour, int aMinute) {
        this.GDate = new EcDate(aYear, aMonth, aDay, aHour, aMinute, 0, 0);
    }

    public DomainDate(int aYear, int aMonth, int aDay, int aHour, int aMinute, int aSecond, int aMillisecond) {
        this.GDate = new EcDate(aYear, aMonth, aDay, aHour, aMinute, aSecond, aMillisecond);
    }

    public static DomainDate today() {
        return new DomainDate(EcDate.today());
    }

    public static DomainDate now() {
        return new DomainDate(EcDate.now());
    }

    public static DomainDate jdate(int year, int month, int day, int hour, int minute) {
        return new DomainDate(year, month, day, hour, minute, 0, 0);
    }

    public static DomainDate jdate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new DomainDate(year, month, day, hour, minute, second, millisecond);
    }

    public static int gdate(int date, int flag) {
        return EcDate.gdate(date, flag);
    }

    public static int gdate(double date, int flag) {
        return EcDate.gdate(date, flag);
    }

    public int gdate(int flag) {
        return this.GDate.gdate(flag);
    }

    public static int between(int date1, int date2, int flag) {
        return new DomainDate(date1).between(new DomainDate(date2), flag);
    }

    public static int between(double date1, double date2, int flag) {
        return new DomainDate(date1).between(new DomainDate(date2), flag);
    }

    public int between(DomainDate date2, int flag) {
        return this.GDate.between(date2.getGDate(), flag);
    }

    public int between(DomainDate date2, DomainInteger flag) {
        return this.between(date2, flag.value);
    }

    public DomainDate add(int value, int flag) {
        DomainDate date = (DomainDate)this.copy();
        date.setValue(this.GDate.add(value, flag));
        return date;
    }

    public DomainDate add(int value, DomainInteger flag) {
        return this.add(value, flag.value);
    }

    public DomainDate add(DomainInteger value, int flag) {
        return this.add(value.value, flag);
    }

    @Override
    public String toString() {
        return this.GDate.toString("%Y%m%d");
    }

    public String toString(String format) {
        return this.GDate.toString(format);
    }

    public String toString(DomainString format) {
        return this.GDate.toString(format.toString());
    }

    public int hashCode() {
        return (int)this.GDate.getValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DomainDate) {
            return this.GDate.equals(((DomainDate)obj).getGDate());
        }
        return false;
    }

    public int compareTo(DomainDate anotherDate) {
        return this.GDate.compareTo(anotherDate.getGDate());
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainDate)o);
    }

    @Override
    public DomainVariable copy() {
        return new DomainDate(this);
    }

    @Override
    public void reset() {
        this.GDate.reset();
    }

    public DomainDate setValue(DomainDate date) {
        this.GDate.setValue(date.getGDate());
        return this;
    }

    public DomainDate setValue(long date) {
        this.GDate.setValue(date);
        return this;
    }

    public DomainDate setValue(DomainExtDate date) {
        this.GDate.setValue((long)date.getValue());
        return this;
    }

    public DomainDate setValue(double date) {
        this.GDate.setValue(date);
        return this;
    }

    public DomainDate setValue(EcDate date) {
        this.GDate.setValue(date);
        return this;
    }

    @Override
    public DomainVariable setValue(DomainVariable v) {
        if (v instanceof DomainDate) {
            return this.setValue((DomainDate)v);
        }
        if (v instanceof DomainExtDate) {
            return this.setValue((DomainExtDate)v);
        }
        if (v instanceof DomainInteger) {
            return this.setValue(((DomainInteger)v).getValue());
        }
        if (v instanceof DomainFloat) {
            return this.setValue(((DomainFloat)v).getValue());
        }
        return null;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        if (s == null || s.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        if (!DomainDate.parseDate("%y%m%d", s.toCharArray(), this, null)) {
            _env.LastError.setValue(3);
            this.reset();
            return this;
        }
        _env.LastError.setValue(0);
        return this;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        if (DomainDate.TextIsLong(s)) {
            try {
                long num = Long.parseLong(s.substring(0, s.length() - 1).getValue());
                return this.setValue(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.setValue(_env, s, "%y%m%d");
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainString s, String fmt) {
        _env.LastError.reset();
        if (s == null || s.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        if (!DomainDate.parseDate(fmt, s.toCharArray(), this, null)) {
            _env.LastError.setValue(3);
            this.reset();
            return this;
        }
        _env.LastError.setValue(0);
        return this;
    }

    public DomainDate setValue(int value, int flag) {
        this.GDate.setValue(value, flag);
        return this;
    }

    private static boolean TextIsLong(DomainString s) {
        int idx;
        if (s == null || s.length() < 1) {
            return false;
        }
        for (idx = 0; idx < s.length() - 1; ++idx) {
            if (Character.isDigit(s.charAt(idx))) continue;
            return false;
        }
        return s.charAt(idx) == 'L';
    }

    static boolean parseDate(String format, char[] buffer, DomainDate result, DomainInteger position) {
        EcDate date = result.getGDate();
        boolean parsed = EcDate.parseDate(format, buffer, date, position);
        result.setValue(date);
        return parsed;
    }

    @Override
    public boolean isTrue() {
        return this.GDate.isTrue();
    }

    public long getValue() {
        return (long)this.GDate.getValue();
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i) {
        return new DomainDate((DomainDate[])a, i);
    }
}

