/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBHandle;

public final class DomainEcNumber {
    private static final int EcG_SIGNMASK = 255;
    private static final int EcG_EXTBIT = 128;
    private static final int EcG_SIGNBIT = 64;
    private static final int EcG_COUNTMASK = 56;
    private static final int EcG_SEEDMASK = 7;
    byte[] unmappedData;
    DomainByteArrayFileMap mappedData;
    int offset;
    int len;
    int[] count = new int[1];

    public DomainEcNumber(byte[] data) {
        this.unmappedData = data;
        this.offset = 0;
        this.len = data.length;
    }

    public DomainEcNumber(byte[] data, int _offset) {
        this.unmappedData = data;
        this.offset = _offset;
        this.len = data.length;
    }

    public DomainEcNumber(DomainByteArrayFileMap mappedData, int _offset) {
        this.mappedData = mappedData;
        this.offset = _offset;
        this.len = mappedData.length();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLen() {
        return this.len;
    }

    public byte[] getUnmappedData() {
        return this.unmappedData;
    }

    public DomainByteArrayFileMap getMappedData() {
        return this.mappedData;
    }

    public int incOffset(int amount) {
        int newOffset = this.offset + amount;
        if (newOffset >= this.len || newOffset < 0) {
            return -1;
        }
        this.offset += amount;
        return this.offset;
    }

    public int getEcNumber() {
        int index = this.offset;
        int val = this.mappedData != null ? DomainEcNumber.EcGetNumber(this.mappedData, index, this.count) : DomainEcNumber.EcGetNumber(this.unmappedData, index, this.count);
        this.offset += this.count[0];
        return val;
    }

    public void skipEcNumber() {
        int index = this.offset;
        this.offset = this.mappedData != null ? (this.offset += DomainEcNumber.EcSkipNumber(this.mappedData, index)) : (this.offset += DomainEcNumber.EcSkipNumber(this.unmappedData, index));
    }

    public DomainString getEcString() {
        int i;
        int slen = 0;
        for (i = this.offset; i < this.len && !(this.mappedData != null ? this.mappedData.getByte(i) == 0 : this.unmappedData[i] == 0); ++i) {
        }
        if (i >= this.len) {
            slen = this.len - this.offset;
            i = this.len - 1;
        } else {
            slen = i - this.offset;
        }
        DomainString s = null;
        s = this.mappedData != null ? new DomainString(this.mappedData, this.offset, slen) : new DomainString(this.unmappedData, this.offset, slen);
        this.offset = i + 1;
        return s;
    }

    public DomainString getEcString(int length) {
        DomainString result = this.mappedData != null ? new DomainString(this.mappedData, this.offset, length) : new DomainString(this.unmappedData, this.offset, length);
        this.offset += length;
        return result;
    }

    public static DomainString EcGetString(byte[] data, int dataIndex, int[] count) {
        int i;
        int slen = 0;
        int len = data.length;
        for (i = dataIndex; i < len && data[i] != 0; ++i) {
        }
        if (i >= len) {
            slen = len - dataIndex;
            i = len - 1;
        } else {
            slen = i - dataIndex;
        }
        DomainString s = new DomainString(data, dataIndex, slen);
        count[0] = slen;
        return s;
    }

    public static DomainString EcGetString(DomainByteArrayFileMap data, int dataIndex, int[] count) {
        int i;
        int slen = 0;
        int len = data.length();
        for (i = dataIndex; i < len && data.getByte(i) != 0; ++i) {
        }
        if (i >= len) {
            slen = len - dataIndex;
            i = len - 1;
        } else {
            slen = i - dataIndex;
        }
        DomainString s = new DomainString(data, dataIndex, slen);
        count[0] = slen;
        return s;
    }

    public static int EcGetNumber(byte[] data, int dataIndex, int[] count) {
        int val;
        count[0] = 1;
        if (((val = data[dataIndex++]) & 0x80) != 0) {
            val = DomainEcNumber.EcGetNumberInner(val, data, dataIndex, count);
        }
        return val;
    }

    public static int EcGetNumber(DomainByteArrayFileMap data, int dataIndex, int[] count) {
        int val;
        count[0] = 1;
        if (((val = data.getByte(dataIndex++)) & 0x80) != 0) {
            val = DomainEcNumber.EcGetNumberInner(val, data, dataIndex, count);
        }
        return val;
    }

    private static int EcGetNumberInner(int local, byte[] data, int dataIndex, int[] count) {
        boolean sign = (local & 0x40) != 0;
        int cnt = (local & 0x38) >> 3;
        local &= 7;
        while (cnt > 0) {
            local <<= 8;
            local += data[dataIndex++] & 0xFF;
            --cnt;
            count[0] = count[0] + 1;
        }
        if (sign) {
            return -local;
        }
        return local;
    }

    private static int EcGetNumberInner(int local, DomainByteArrayFileMap data, int dataIndex, int[] count) {
        boolean sign = (local & 0x40) != 0;
        int cnt = (local & 0x38) >> 3;
        local &= 7;
        while (cnt > 0) {
            local <<= 8;
            local += data.getByte(dataIndex++) & 0xFF;
            --cnt;
            count[0] = count[0] + 1;
        }
        if (sign) {
            return -local;
        }
        return local;
    }

    public static void EcSkipNumber(byte[] data, int dataIndex, int[] count) {
        byte val;
        count[0] = 1;
        if (((val = data[dataIndex++]) & 0x80) != 0) {
            count[0] = count[0] + ((val & 0x38) >> 3);
        }
    }

    public static void EcSkipNumber(DomainByteArrayFileMap data, int dataIndex, int[] count) {
        byte val;
        count[0] = 1;
        if (((val = data.getByte(dataIndex++)) & 0x80) != 0) {
            count[0] = count[0] + ((val & 0x38) >> 3);
        }
    }

    public static int EcSkipNumber(byte[] data, int dataIndex) {
        byte val;
        int count = 1;
        if (((val = data[dataIndex++]) & 0x80) != 0) {
            count += (val & 0x38) >> 3;
        }
        return count;
    }

    public static int EcSkipNumber(DomainByteArrayFileMap data, int dataIndex) {
        byte val;
        int count = 1;
        if (((val = data.getByte(dataIndex++)) & 0x80) != 0) {
            count += (val & 0x38) >> 3;
        }
        return count;
    }

    public static void EcSkipNumber(DBHandle fd) {
        int count = 1;
        int bufIndex = fd.getBufIndex();
        byte val = fd.getMappedBuf() != null ? fd.getMappedBuf().getByte(bufIndex) : fd.getUnmappedBuf()[bufIndex];
        if ((val & 0x80) != 0) {
            count += (val & 0x38) >> 3;
        }
        fd.setBufIndex(bufIndex + count);
    }
}

