/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;

public final class DomainInteger
extends DomainVariable {
    private static final long serialVersionUID = -3019266531822843376L;
    protected int value;

    public DomainInteger() {
    }

    public DomainInteger(int value) {
        this.value = value;
    }

    public DomainInteger(boolean value) {
        this.value = value ? 1 : 0;
    }

    public DomainInteger(DomainEnvironment _env, String s) {
        this.setValue(_env, s);
    }

    public DomainInteger(DomainEnvironment _env, DomainString s) {
        this.setValue(_env, s);
    }

    public DomainInteger(DomainInteger di) {
        this.value = di.value;
    }

    public DomainInteger(DomainInteger[] a, int i) {
        this.DVArray = a;
        this.DVIndex = i;
    }

    @Override
    public boolean isTrue() {
        return this.value != 0;
    }

    @Override
    public void reset() {
        this.value = 0;
    }

    public int compareTo(DomainInteger anotherInteger) {
        int thisVal = this.value;
        int anotherVal = anotherInteger.value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainInteger)o);
    }

    public int getValue() {
        return this.value;
    }

    public DomainInteger setValue(int aValue) {
        this.value = aValue;
        return this;
    }

    public DomainInteger setValue(long aValue) {
        this.value = (int)aValue;
        return this;
    }

    public DomainInteger setValue(DomainInteger di) {
        this.value = di.value;
        return this;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        if (s == null || s.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        try {
            int index;
            char[] charArr = s.toCharArray();
            for (index = 0; index < charArr.length && charArr[index] == ' '; ++index) {
            }
            this.value = DomainInteger.parseInt(charArr, index, charArr.length, 10);
            return this;
        }
        catch (NumberFormatException ex) {
            _env.LastError.setValue(1);
            this.reset();
            return this;
        }
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        _env.LastError.reset();
        if (s == null || s.count <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        try {
            int index;
            char[] charArr = s.value;
            for (index = 0; index < s.count && charArr[index] == ' '; ++index) {
            }
            this.value = DomainInteger.parseInt(charArr, index, s.count, 10);
            return this;
        }
        catch (NumberFormatException ex) {
            _env.LastError.setValue(1);
            this.reset();
            return this;
        }
    }

    public static int parseInt(DomainString str, int radix) throws NumberFormatException {
        return DomainInteger.parseInt(str.value, 0, str.count, radix);
    }

    static int parseInt(char[] buffer, int begin, int end, int radix) throws NumberFormatException {
        if (buffer == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        if (begin >= end) {
            throw new NumberFormatException("");
        }
        int result = 0;
        boolean negative = false;
        int i = begin;
        int max = end;
        if (max > 0) {
            int digit;
            int limit;
            if (buffer[begin] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(buffer[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(buffer[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + String.valueOf(buffer, begin, end - begin) + "\"");
        }
        return -result;
    }

    @Override
    public DomainVariable setValue(DomainVariable v) {
        if (v instanceof DomainInteger) {
            this.value = ((DomainInteger)v).value;
        } else if (v instanceof DomainString) {
            this.setValue(null, ((DomainString)v).toString());
        }
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DomainInteger) {
            return this.value == ((DomainInteger)obj).value;
        }
        return false;
    }

    public boolean equals(int val) {
        return this.value == val;
    }

    @Override
    public DomainVariable copy() {
        return new DomainInteger(this);
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i) {
        return new DomainInteger((DomainInteger[])a, i);
    }
}

