/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.db;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DBFile {
    public static final int DbFRAME_UNKNOWN = 0;
    public static final int DbFRAME_LOGIC = 1;
    public static final int DbFRAME_STRING = 2;
    public static final int DbFRAME_HTML = 3;
    public static final int DbFRAME_IMAGE = 4;
    public static final int DbFRAME_NOTE = 5;
    public static final int DbVERSION_DSL = 5;
    public static final int DbVERSION_STRING = 1;
    public static final int DbVERSION_REFERENCE = 1;
    public static final int DbVERSION_IMAGE = 1;
    public static final int DbVERSION_NOTES = 1;
    public static final int DbINMEMORY_NO = 0;
    public static final int DbINMEMORY_MEMLOAD = 1;
    public static final int DbINMEMORY_MEMMAP = 2;
    public static final int DbINMEMORY_NOCACHE = 3;
    public static final int DbFILELOAD_OFF = 0;
    public static final int DbFILELOAD_ON = 1;
    public static final int DbFILELOAD_FORCE = 2;
    public static final int DB_ROOT_SIZE = 2048;
    public static final String DbLOAD_PARENT = "..";
    public static final String DbLOAD_PREV = "<";
    public static final String DbLOAD_NEXT = ">";
    public static final String DbLOAD_CHILD = ":";
    public static final String DbLOAD_SELF = ".";
    public static final String DbLOAD_LAST = ">>";
    private static final ConcurrentMap byteMap = new ConcurrentHashMap();
    String name;
    DomainString alist;
    DomainString prefix;
    DomainString grules;
    DomainString crules;
    int magic;
    File fd;
    InputStream inFile;
    String resourceName;
    boolean open;
    int sibling;
    int lru;
    int longest;
    boolean compressed;
    int version;
    int index;
    int heap;
    int classLength;
    int attribs;
    int memsize;
    int offset;
    int timeoff;
    int timestamp;
    DomainString revision;
    DomainString title;
    int textindex;
    int linear;
    int inMemory;
    int tblCachePages;
    int mapfp;
    int findxfp;
    private String encoding;
    byte[] unmappedFile;
    DomainByteArrayFileMap mappedFile;

    public boolean isOpen() {
        return this.open;
    }

    public int getSibling() {
        return this.sibling;
    }

    public void setSibling(int sib) {
        this.sibling = sib;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public int getInMemory() {
        return this.inMemory;
    }

    public void setInMemory(int value) {
        this.inMemory = value;
    }

    public int getTblCachePages() {
        return this.tblCachePages;
    }

    public void setTblCachePages(int value) {
        this.tblCachePages = value;
    }

    public int getMapfp() {
        return this.mapfp;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int open(DBControl dbControl) {
        try {
            byte[] buffer = new byte[2048];
            this.inFile = null;
            this.fd = new File(this.name);
            if (!this.fd.exists()) {
                this.resourceName = this.name;
                this.inFile = this.getFileFromResource(this.resourceName);
                if (this.inFile == null) {
                    return 120;
                }
            }
            if (this.index == 0) {
                if (this.inFile == null) {
                    this.inFile = new FileInputStream(this.fd);
                }
                if (this.inFile.read(buffer) != 2048) {
                    return 110;
                }
                this.magic = buffer[0];
            }
            switch (this.magic) {
                case 1: {
                    if (dbControl.ignoreKb) {
                        if (this.inFile != null) {
                            this.inFile.close();
                        }
                        this.fd = null;
                        this.open = false;
                        return 0;
                    }
                }
                case 2: 
                case 3: 
                case 4: {
                    if (this.index == 0) {
                        this.openFrameDB(buffer);
                    }
                    this.memoryLoadFrame();
                    break;
                }
                case 5: {
                    if (this.index == 0) {
                        this.openFrameDB(buffer);
                    }
                    this.inMemory = 0;
                    break;
                }
                default: {
                    return 120;
                }
            }
            this.open = true;
        }
        catch (IOException ex) {
            return 120;
        }
        return 0;
    }

    public void close(boolean last) throws DomainException {
        if (last) {
            this.closeFrameDB();
        }
        if (!this.open) {
            return;
        }
        switch (this.magic) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.memoryCloseFrame();
                break;
            }
            default: {
                throw new DomainException(1283, new Object[]{new Integer(this.magic)});
            }
        }
        if (this.fd != null) {
            this.fd = null;
        }
        this.open = false;
    }

    void openFrameDB(byte[] buffer) throws DomainException {
        int count;
        int _version;
        boolean found = false;
        DomainEcNumber ecNumber = new DomainEcNumber(buffer);
        ecNumber.skipEcNumber();
        this.compressed = ecNumber.getEcNumber() != 0;
        ecNumber.skipEcNumber();
        this.version = ecNumber.getEcNumber();
        switch (this.magic) {
            case 1: {
                _version = 5;
                break;
            }
            case 2: {
                _version = 1;
                break;
            }
            case 3: {
                _version = 1;
                break;
            }
            case 5: {
                _version = 1;
                break;
            }
            default: {
                _version = 1;
            }
        }
        if (this.version != _version) {
            throw new DomainException(1286, new Object[]{this.name, new Integer(this.version), new Integer(_version)});
        }
        this.index = ecNumber.getEcNumber();
        this.memsize = ecNumber.getEcNumber();
        this.offset = ecNumber.getEcNumber();
        this.heap = ecNumber.getEcNumber();
        if (this.heap != 0) {
            count = ecNumber.getEcNumber();
            this.grules = ecNumber.getEcString(count);
        }
        this.classLength = ecNumber.getEcNumber();
        if (this.classLength != 0 && (count = ecNumber.getEcNumber()) > 0) {
            found = true;
            this.crules = ecNumber.getEcString(count);
        }
        ecNumber.skipEcNumber();
        this.encoding = ecNumber.getEcNumber() == 1 ? "IBM1047" : "ISO-8859-1";
        this.revision = ecNumber.getEcString();
        this.timeoff = ecNumber.getOffset();
        this.timestamp = ecNumber.getEcNumber();
        this.title = ecNumber.getEcString();
        this.mapfp = ecNumber.getEcNumber();
        count = ecNumber.getEcNumber();
        this.attribs = ecNumber.getEcNumber();
        if (this.attribs != 0) {
            this.alist = ecNumber.getEcString(count);
            found = true;
        }
        this.prefix = ecNumber.getEcString();
        this.textindex = ecNumber.getEcNumber();
        this.linear = ecNumber.getEcNumber();
        this.findxfp = ecNumber.getEcNumber();
        ecNumber.getEcString();
        ecNumber.getEcNumber();
    }

    void closeFrameDB() {
        this.alist = null;
        this.grules = null;
        this.crules = null;
        this.prefix = null;
    }

    private InputStream getFileFromResource(String resource) {
        if (resource == null || resource.length() < 2) {
            return null;
        }
        return DBFile.class.getResourceAsStream(resource);
    }

    void memoryLoadFrame() throws DomainException {
        if (!this.name.endsWith(".kb")) {
            switch (this.inMemory) {
                case 1: {
                    if (!this.compressed) {
                        FileBytesHandle fbh = new FileBytesHandle(){

                            @Override
                            protected void setBytes() throws DomainException {
                                try {
                                    InputStream in = DBFile.this.resourceName == null ? new FileInputStream(DBFile.this.fd) : DBFile.this.getFileFromResource(DBFile.this.resourceName);
                                    DBFile.this.unmappedFile = new byte[DBFile.this.memsize];
                                    in.skip(DBFile.this.offset);
                                    int totalRead = 0;
                                    int bytesLeft = DBFile.this.memsize;
                                    int idx = 0;
                                    int bytesRead = 0;
                                    while ((bytesRead = in.read(DBFile.this.unmappedFile, idx, bytesLeft)) >= 1) {
                                        bytesLeft -= bytesRead;
                                        idx += bytesRead;
                                        if ((totalRead += bytesRead) < DBFile.this.memsize) continue;
                                    }
                                    if (totalRead != DBFile.this.memsize) {
                                        throw new DomainException(1282, new Object[]{DBFile.this.name, new Integer(DBFile.this.memsize)});
                                    }
                                    in.close();
                                    this.bytes = DBFile.this.unmappedFile;
                                }
                                catch (IOException e) {
                                    throw new DomainException(1294, new Object[]{DBFile.this.name, new Integer(DBFile.this.offset)});
                                }
                            }

                            @Override
                            protected void cleanup() {
                                byteMap.remove(DBFile.this.name);
                                if (this.bytes instanceof DomainByteArrayFileMap) {
                                    ((DomainByteArrayFileMap)this.bytes).close();
                                }
                            }
                        };
                        FileBytesHandle existingFbh = byteMap.putIfAbsent(this.name, fbh);
                        if (existingFbh != null) {
                            fbh = existingFbh;
                        }
                        fbh.incrementCount();
                        this.unmappedFile = (byte[])fbh.getBytes();
                    }
                    this.fd = null;
                    break;
                }
                case 2: {
                    if (this.compressed) break;
                    this.memsize += this.offset;
                    this.offset = 0;
                    this.mappedFile = this.memoryMap();
                    if (this.mappedFile != null) break;
                    throw new DomainException(1295, new Object[]{this.name});
                }
                default: {
                    this.offset = this.offset;
                }
            }
        }
    }

    DomainByteArrayFileMap memoryMap() {
        try {
            DomainByteArrayFileMap byteArray = null;
            FileBytesHandle fbh = new FileBytesHandle(){

                @Override
                protected void setBytes() throws DomainException {
                    this.bytes = new DomainByteArrayFileMap(4096, DBFile.this.tblCachePages, DBFile.this.fd);
                }

                @Override
                protected void cleanup() {
                    byteMap.remove(DBFile.this.name);
                    if (this.bytes instanceof DomainByteArrayFileMap) {
                        ((DomainByteArrayFileMap)this.bytes).close();
                    }
                }
            };
            FileBytesHandle existingFbh = byteMap.putIfAbsent(this.name, fbh);
            if (existingFbh != null) {
                fbh = existingFbh;
            }
            fbh.incrementCount();
            byteArray = (DomainByteArrayFileMap)fbh.getBytes();
            return byteArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    void memoryCloseFrame() {
        switch (this.inMemory) {
            case 1: {
                try {
                    if (this.unmappedFile == null) break;
                    if (this.inFile != null) {
                        this.inFile.close();
                        this.inFile = null;
                    }
                    this.unmappedFile = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    if (this.mappedFile == null) break;
                    this.memoryUnmap();
                    if (this.inFile != null) {
                        this.inFile.close();
                        this.inFile = null;
                    }
                    this.mappedFile = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
        }
    }

    void memoryUnmap() {
    }

    public static void ReleaseFileMaps(String[] resourceList) {
        if (resourceList != null) {
            for (int idx = 0; idx < resourceList.length; ++idx) {
                String name = resourceList[idx];
                FileBytesHandle fbh = (FileBytesHandle)byteMap.get(name);
                if (fbh == null) continue;
                fbh.decrementCount();
            }
        }
    }

    public static void RemoveFileMap(String name) {
        FileBytesHandle fbh = (FileBytesHandle)byteMap.get(name);
        if (fbh != null) {
            fbh.forceRemove();
        }
    }

    static abstract class FileBytesHandle {
        private int count = 0;
        protected volatile Object bytes = null;

        FileBytesHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementCount() {
            FileBytesHandle fileBytesHandle = this;
            synchronized (fileBytesHandle) {
                ++this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementCount() {
            FileBytesHandle fileBytesHandle = this;
            synchronized (fileBytesHandle) {
                --this.count;
                if (this.count < 1) {
                    this.cleanup();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getBytes() {
            if (this.bytes == null) {
                FileBytesHandle fileBytesHandle = this;
                synchronized (fileBytesHandle) {
                    if (this.bytes == null) {
                        this.setBytes();
                    }
                }
            }
            return this.bytes;
        }

        protected abstract void setBytes() throws DomainException;

        protected abstract void cleanup();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceRemove() {
            FileBytesHandle fileBytesHandle = this;
            synchronized (fileBytesHandle) {
                this.count = 0;
                this.cleanup();
            }
        }
    }
}

