/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.db;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;

public final class DBHandle {
    byte[] unmappedBuf;
    DomainByteArrayFileMap mappedBuf;
    int bufIndex;
    int ptr;
    int fd;
    int[] count = new int[1];

    public DBHandle() {
    }

    protected DBHandle(DBHandle handle) throws DomainException {
        if (this.mappedBuf != null) {
            this.mappedBuf = new DomainByteArrayFileMap(handle.mappedBuf);
        }
        if (this.unmappedBuf != null) {
            this.unmappedBuf = new byte[handle.unmappedBuf.length];
            System.arraycopy(handle.unmappedBuf, 0, this.unmappedBuf, 0, handle.unmappedBuf.length);
        }
        this.bufIndex = handle.bufIndex;
        this.ptr = handle.ptr;
        this.fd = handle.fd;
    }

    public DBHandle(int aPtr, int aFd) {
        this.ptr = aPtr;
        this.fd = aFd;
    }

    public void reset() {
        this.mappedBuf = null;
        this.unmappedBuf = null;
        this.bufIndex = 0;
        this.ptr = 0;
        this.fd = 0;
    }

    public void setPtr(int aPtr) {
        this.ptr = aPtr;
    }

    public int getPtr() {
        return this.ptr;
    }

    public DomainByteArrayFileMap getMappedBuf() {
        return this.mappedBuf;
    }

    public byte[] getUnmappedBuf() {
        return this.unmappedBuf;
    }

    public int getBufIndex() {
        return this.bufIndex;
    }

    public void setBufIndex(int index) {
        this.bufIndex = index;
    }

    public byte[] getByteArray(int len) {
        byte[] results = new byte[len];
        if (this.mappedBuf != null) {
            int i = 0;
            while (i < len && this.bufIndex < this.mappedBuf.length()) {
                results[i] = this.mappedBuf.getByte(this.bufIndex);
                ++i;
                ++this.bufIndex;
            }
        } else {
            int i = 0;
            while (i < len && this.bufIndex < this.unmappedBuf.length) {
                results[i] = this.unmappedBuf[this.bufIndex];
                ++i;
                ++this.bufIndex;
            }
        }
        return results;
    }

    public char[] getCharArray(int len) {
        char[] results = new char[len];
        if (this.mappedBuf != null) {
            int i = 0;
            while (i < len && this.bufIndex < this.mappedBuf.length()) {
                results[i] = (char)this.mappedBuf.getByte(this.bufIndex);
                ++i;
                ++this.bufIndex;
            }
        } else {
            int i = 0;
            while (i < len && this.bufIndex < this.unmappedBuf.length) {
                results[i] = (char)this.unmappedBuf[this.bufIndex];
                ++i;
                ++this.bufIndex;
            }
        }
        return results;
    }

    public DomainString getString() {
        DomainString value = null;
        value = this.mappedBuf != null ? DomainEcNumber.EcGetString(this.mappedBuf, this.bufIndex, this.count) : DomainEcNumber.EcGetString(this.unmappedBuf, this.bufIndex, this.count);
        this.bufIndex += this.count[0];
        return value;
    }

    public int getNumber() {
        int value = 0;
        value = this.mappedBuf != null ? DomainEcNumber.EcGetNumber(this.mappedBuf, this.bufIndex, this.count) : DomainEcNumber.EcGetNumber(this.unmappedBuf, this.bufIndex, this.count);
        this.bufIndex += this.count[0];
        return value;
    }
}

