/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.ec;

import com.mmmhis.domain.DateFormatter;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.ec.EcMath;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class EcDate {
    public static final String INTERNAL_DATE_IN = "%y%m%d";
    public static final String INTERNAL_TIME_IN = "%y%m%d%oH%oM";
    public static final String INTERNAL_DATE_OUT = "%Y%m%d";
    public static final String INTERNAL_TIME_OUT = "%Y%m%d%H%M";
    public static final String INTERFACE_DATE_IN = "%m%d%y";
    public static final String INTERFACE_TIME_IN = "%m%d%y%oH%oM";
    public static final int GDATE_YEAR = 0;
    public static final int GDATE_MONTH = 1;
    public static final int GDATE_DAY = 2;
    public static final int GDATE_HOUR = 3;
    public static final int GDATE_MINUTE = 4;
    public static final int GDATE_WDAY = 5;
    public static final int GDATE_SECOND = 6;
    public static final int GDATE_MILLISECOND = 7;
    private static final int DBL_DIG = 15;
    private double jextdate;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int dow;
    private int second;
    private int millisecond;

    public EcDate() {
        this.reset();
    }

    public EcDate(long date) {
        this.setValue(date);
    }

    public EcDate(EcDate date) {
        this.setValue(date);
    }

    public EcDate(double date) {
        this.setValue(date);
    }

    public EcDate(int aYear, int aMonth, int aDay, int aHour, int aMinute, int aSecond, int aMillisecond) {
        this.year = aYear;
        this.month = aMonth;
        this.day = aDay;
        this.hour = aHour;
        this.minute = aMinute;
        this.second = aSecond;
        this.millisecond = aMillisecond;
        this.setJdate();
        try {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute);
            this.dow = cal.get(7) - 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void normalizeYear() {
        if (this.year < 100) {
            try {
                Calendar rightNow = Calendar.getInstance();
                int currentYear = rightNow.get(1);
                int currentCentury = currentYear / 100 * 100;
                this.year += currentCentury;
                if (this.year <= currentYear - 90) {
                    this.year += 100;
                } else if (this.year > currentYear + 10) {
                    this.year -= 100;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setJdate() {
        long j0 = (this.month - 14) / 12;
        long d0 = (long)(this.day - 32075) + 1461L * ((long)this.year + 4800L + j0) / 4L + 367L * ((long)(this.month - 2) - j0 * 12L) / 12L - 3L * (((long)(this.year + 4900) + j0) / 100L) / 4L + 68569L;
        long jdate = (d0 &= 0xFFFFFFFFL) < 2447393L ? 0L : d0 - 2447393L;
        jdate = jdate * 1440L & 0xFFFFFFFFL;
        this.jextdate = this.second != 0 || this.millisecond != 0 ? EcMath.round((double)jdate + (double)(this.second * 1000 + this.millisecond) / 60000.0, 14) : (double)(jdate += (long)(this.hour * 60 + this.minute));
    }

    public void setGDate(double jextdate) {
        this.jextdate = jextdate;
        this.setJdateParts();
    }

    private void setJdateParts() {
        long jdate = (long)this.jextdate;
        long d = (jdate &= 0xFFFFFFFFL) / 1440L;
        this.dow = (int)((d + 1L) % 7L);
        long n = 4L * (d += 2447393L) / 146097L;
        long m = 4000L * ((d -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
        d = -1461L * m / 4L + 31L + d;
        long j = 80L * d / 2447L;
        long k = j / 11L;
        this.day = (int)(d - 2447L * j / 80L);
        this.month = (int)(-12L * k + j + 2L);
        this.year = (int)(100L * (n - 49L) + m + k);
        long t = jdate % 1440L;
        this.hour = (int)(t / 60L);
        this.minute = (int)(t % 60L);
        double stime = (this.jextdate - Math.floor(this.jextdate)) * 60.0;
        this.second = (int)stime;
        double mtime = (stime - Math.floor(stime)) * 1000.0;
        this.millisecond = (int)mtime;
    }

    private static EcDate getCurrentDate(boolean time) {
        return EcDate.getDate(new Date(), time);
    }

    private static EcDate getDate(Date date, boolean time) {
        EcDate result = new EcDate();
        try {
            TimeZone tz = TimeZone.getDefault();
            GregorianCalendar cal = new GregorianCalendar(tz);
            cal.setTime(date);
            result.year = cal.get(1);
            result.month = cal.get(2) + 1;
            result.day = cal.get(5);
            result.dow = cal.get(7);
            if (time) {
                result.hour = cal.get(11);
                result.minute = cal.get(12);
                result.second = cal.get(13);
                result.millisecond = cal.get(14);
            }
            result.setJdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    void normalize() {
        this.setJdate();
        this.setJdateParts();
    }

    boolean isNormal() {
        int day = this.day;
        int month = this.month;
        int year = this.year;
        this.setJdate();
        this.setJdateParts();
        return day == this.day && month == this.month && year == this.year;
    }

    public static EcDate today() {
        return EcDate.getCurrentDate(false);
    }

    public static EcDate now() {
        return EcDate.getCurrentDate(true);
    }

    public static EcDate jdate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new EcDate(year, month, day, hour, minute, second, millisecond);
    }

    public static int gdate(int date, int flag) {
        return new EcDate(date).gdate(flag);
    }

    public static int gdate(double date, int flag) {
        return new EcDate(date).gdate(flag);
    }

    public int gdate(int flag) {
        switch (flag) {
            case 0: {
                return this.year;
            }
            case 1: {
                return this.month;
            }
            case 2: {
                return this.day;
            }
            case 3: {
                return this.hour;
            }
            case 4: {
                return this.minute;
            }
            case 6: {
                return this.second;
            }
            case 7: {
                return this.millisecond;
            }
            case 5: {
                return this.dow;
            }
        }
        return 0;
    }

    public static int between(int date1, int date2, int flag) {
        return new EcDate(date1).between(new EcDate(date2), flag);
    }

    public static int between(double date1, double date2, int flag) {
        return new EcDate(date1).between(new EcDate(date2), flag);
    }

    public int between(EcDate date2, int flag) {
        int result;
        EcDate date1 = this;
        if (date1.compareTo(date2) > 0) {
            EcDate temp = date1;
            date1 = date2;
            date2 = temp;
        }
        switch (flag) {
            case 0: {
                result = date2.year - date1.year;
                if (date2.month >= date1.month && (date2.month != date1.month || date2.day >= date1.day)) break;
                --result;
                break;
            }
            case 1: {
                result = (date2.year - date1.year) * 12 + (date2.month - date1.month);
                if (date2.day >= date1.day) break;
                --result;
                break;
            }
            case 2: {
                result = (int)(((long)date2.jextdate - (long)date1.jextdate) / 1440L);
                break;
            }
            case 3: {
                result = (int)(((long)date2.jextdate - (long)date1.jextdate) / 60L);
                break;
            }
            case 4: {
                result = (int)((long)date2.jextdate - (long)date1.jextdate);
                break;
            }
            case 5: {
                result = (int)(((long)date2.jextdate - (long)date1.jextdate) / 10080L);
                break;
            }
            case 6: {
                result = (int)((date2.jextdate - date1.jextdate) * 60.0);
                break;
            }
            case 7: {
                result = (int)((date2.jextdate - date1.jextdate) * 60000.0);
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public EcDate add(int value, int flag) {
        int[] EOM = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        EcDate date = new EcDate(this);
        switch (flag) {
            case 0: {
                date.year += value;
                break;
            }
            case 1: {
                date.month += value;
                while (date.month < 1 || date.month > 12) {
                    if (date.month < 1) {
                        date.month += 12;
                        --date.year;
                        continue;
                    }
                    date.month -= 12;
                    ++date.year;
                }
                if (date.year % 4 == 0 && date.year % 100 != 0 || date.year % 400 == 0) {
                    EOM[2] = EOM[2] + 1;
                }
                if (date.day <= EOM[date.month]) break;
                date.day = EOM[date.month];
                break;
            }
            case 2: {
                date.day += value;
                break;
            }
            case 3: {
                date.hour += value;
                break;
            }
            case 4: {
                date.minute += value;
                break;
            }
            case 5: {
                date.day += value * 7;
                break;
            }
            case 6: {
                date.second += value;
                break;
            }
            case 7: {
                date.millisecond += value;
            }
        }
        date.normalize();
        return date;
    }

    private Calendar toCalendar() {
        GregorianCalendar cal = null;
        try {
            cal = new GregorianCalendar();
            cal.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
            cal.set(14, this.millisecond);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cal;
    }

    public String toString() {
        return this._toString(INTERNAL_DATE_OUT);
    }

    private String _toString(String format) {
        try {
            DateFormatter df = new DateFormatter(format);
            return df.format(this.toCalendar());
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String toString(String format) {
        return this._toString(format);
    }

    public int hashCode() {
        return (int)this.jextdate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EcDate) {
            return this.jextdate == ((EcDate)obj).jextdate;
        }
        return false;
    }

    public int compareTo(EcDate anotherDate) {
        return EcMath.floatCompare(this.jextdate, anotherDate.jextdate);
    }

    public int compareTo(Object o) {
        return this.compareTo((EcDate)o);
    }

    private void zero() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.millisecond = 0;
    }

    public void reset() {
        this.jextdate = 0.0;
        this.setJdateParts();
    }

    public EcDate setValue(EcDate date) {
        this.jextdate = date.jextdate;
        this.year = date.year;
        this.month = date.month;
        this.day = date.day;
        this.hour = date.hour;
        this.minute = date.minute;
        this.dow = date.dow;
        this.second = date.second;
        this.millisecond = date.millisecond;
        return this;
    }

    public EcDate setValue(long date) {
        this.setGDate(date);
        return this;
    }

    public EcDate setValue(double date) {
        this.setGDate(date);
        return this;
    }

    public EcDate setValue(int value, int flag) {
        switch (flag) {
            case 0: {
                this.year = value;
                break;
            }
            case 1: {
                this.month = value;
                break;
            }
            case 2: {
                this.day = value;
                break;
            }
            case 3: {
                this.hour = value;
                break;
            }
            case 4: {
                this.minute = value;
                break;
            }
            case 6: {
                this.second = value;
                break;
            }
            case 7: {
                this.millisecond = value;
            }
        }
        return this;
    }

    public static boolean parseDate(String format, char[] buffer, EcDate result, DomainInteger position) {
        int strLen;
        boolean optional = false;
        boolean found = false;
        boolean strict = false;
        boolean yearSet = false;
        int fmtIndex = 0;
        int strIndex = 0;
        int state = 0;
        int width = 0;
        if (position != null) {
            position.setValue(0);
        }
        if ((strLen = buffer.length) == 0) {
            return false;
        }
        char[] fmtArr = format.toCharArray();
        result.zero();
        block22: while (fmtIndex < fmtArr.length) {
            block0 : switch (fmtArr[fmtIndex]) {
                case '%': {
                    if (fmtArr[++fmtIndex] == 'o') {
                        ++fmtIndex;
                        optional = true;
                    } else {
                        optional = false;
                    }
                    switch (fmtArr[fmtIndex]) {
                        case 's': {
                            strict = true;
                            ++fmtIndex;
                            continue block22;
                        }
                        case 'm': {
                            state = 1;
                            width = 2;
                            break block0;
                        }
                        case 'd': {
                            state = 2;
                            width = 2;
                            break block0;
                        }
                        case 'Y': 
                        case 'y': {
                            state = 3;
                            width = 4;
                            yearSet = true;
                            break block0;
                        }
                        case 'H': {
                            state = 4;
                            width = 2;
                            break block0;
                        }
                        case 'M': {
                            state = 5;
                            width = 2;
                            break block0;
                        }
                        case 'C': {
                            state = 6;
                            width = 2;
                            break block0;
                        }
                        case 'L': {
                            state = 7;
                            width = 3;
                            break block0;
                        }
                    }
                    continue block22;
                }
                default: {
                    if (strIndex < strLen && fmtArr[fmtIndex] == buffer[strIndex]) {
                        ++strIndex;
                        ++fmtIndex;
                        continue block22;
                    }
                    result.reset();
                    return false;
                }
            }
            int n = 0;
            found = false;
            int reqLength = width;
            while (strIndex < strLen && (Character.isWhitespace(buffer[strIndex]) || !strict && DomainString.ispunct(buffer[strIndex]))) {
                ++strIndex;
                --reqLength;
            }
            while (strIndex < strLen && Character.isDigit(buffer[strIndex]) && width-- > 0 && (!strict || reqLength > 0)) {
                char c = buffer[strIndex++];
                n = 10 * n + (c - 48);
                found = true;
                --reqLength;
            }
            switch (state) {
                case 1: {
                    result.setValue(n, 1);
                    break;
                }
                case 2: {
                    result.setValue(n, 2);
                    break;
                }
                case 3: {
                    result.setValue(n, 0);
                    break;
                }
                case 4: {
                    result.setValue(n, 3);
                    break;
                }
                case 5: {
                    result.setValue(n, 4);
                    break;
                }
                case 6: {
                    result.setValue(n, 6);
                    break;
                }
                case 7: {
                    result.setValue(n, 7);
                }
            }
            if (!found && !optional || strict && reqLength != 0) {
                result.reset();
                return false;
            }
            state = 0;
            ++fmtIndex;
        }
        if (yearSet) {
            result.normalizeYear();
        }
        if (!result.isNormal()) {
            result.reset();
            return false;
        }
        result.setJdate();
        if (position != null) {
            position.setValue(strIndex);
        }
        return true;
    }

    public boolean isTrue() {
        return this.jextdate != 0.0;
    }

    public double getValue() {
        return this.jextdate;
    }
}

