/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.ec.EcUtil;
import com.mmmhis.domain.le.LEHandle;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLHandle;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLStruct;
import com.mmmhis.domain.table.TBLTable;

public class TBLCompaction {
    int bufSize;
    byte[] buffer;
    int index;
    LEHandle handle;
    TBLHandle th;
    TBLFile tblFile;
    TBLTable table;
    TBLPageNumber[] mapping;
    int mapSize;
    int pages;
    int numTab;
    int pgno;
    int pgSize;
    int codePage;
    int objCount;
    boolean wantConsolid;
    boolean consolidated;
    byte[] secName;
    int nameIndex;
    byte[] secBuf;
    int secIndex;
    int[] xlate;
    private static final int OBUFSIZE = 1024;
    byte[] sectionEnd = new byte[]{62, 10, 60, 69, 78, 68, 62, 10};
    byte[] aBuf = new byte[]{37, 65};
    byte[] tBuf = new byte[]{37, 84};
    byte[] zBuf = new byte[]{37, 90};

    public TBLCompaction(LEHandle le, int codePage, int[] xlate, boolean wantConsolid, TBLFile tblFile) {
        this.handle = le;
        this.codePage = codePage;
        this.xlate = xlate;
        this.wantConsolid = wantConsolid;
        this.bufSize = 1024;
        this.buffer = new byte[this.bufSize];
        this.index = 0;
        this.tblFile = tblFile;
        this.pgSize = tblFile.pageSize;
        this.pages = tblFile.endOffset / tblFile.pageSize;
        this.mapSize = this.pages * 2;
        this.mapping = new TBLPageNumber[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            this.mapping[i] = new TBLPageNumber();
        }
        this.th = new TBLHandle(xlate);
        this.th.attachFile(this.tblFile);
        this.th.resetSection();
    }

    public static byte[] resizeArray(byte[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        byte[] newArray = new byte[newSize];
        int preserveLenth = Math.min(oldSize, newSize);
        if (preserveLenth > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLenth);
        }
        return newArray;
    }

    private void appendBuf(int bytes) {
        while (this.bufSize <= this.index + bytes) {
            int offset = this.index;
            this.bufSize += 1024;
            this.buffer = TBLCompaction.resizeArray(this.buffer, this.bufSize);
            this.index = offset;
        }
    }

    public int compactStruct(int itype, TBLStruct def) {
        while (def != null) {
            int len = def.name.length() + 1;
            this.appendBuf(len + 65 + 2);
            this.buffer[this.index++] = (byte)itype;
            this.buffer[this.index++] = (byte)def.type;
            EcUtil.strcpy(this.buffer, this.index, def.name.toByteArray(), 0);
            this.index += len;
            this.index += EcUtil.putNumber(this.buffer, this.index, def.elements);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.offset);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.length);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.bitmask);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.datatype);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.strix);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.numstr);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.coloff);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.numcol);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.precision);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.srcOffset);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.srcString);
            this.index += EcUtil.putNumber(this.buffer, this.index, def.srcColumn);
            if (def.type == 5 && (def.datatype == 11 || def.datatype == 17)) {
                len = def.components.name.length() + 1;
                this.appendBuf(len);
                EcUtil.strcpy(this.buffer, this.index, def.components.name.toByteArray(), 0);
                this.index += len;
            }
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int rc = this.compactStruct(7, def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    int rc = this.compactStruct(6, def.components);
                    if (rc == 0) break;
                    return rc;
                }
            }
            if (itype == 4) {
                itype = 5;
            }
            def = def.next;
        }
        this.appendBuf(1);
        this.buffer[this.index++] = 0;
        return 0;
    }

    public int compactSection(boolean gateway) {
        TBLTable[] tableArr;
        DomainString name = new DomainString();
        DomainString value = new DomainString();
        int i = 0;
        byte[] section = this.th.sectionPath();
        this.index = 0;
        int rc = this.th.firstTag();
        while (rc == 0) {
            rc = this.th.thisTag(name, value);
            if (rc != 0) {
                return rc;
            }
            this.appendBuf(name.length() + value.length() + 3);
            EcUtil.strcpy(this.buffer, this.index, name.toByteArray(), 0);
            this.index += name.length();
            this.buffer[this.index++] = (byte)TBLTable.convertChar(61, this.xlate);
            EcUtil.strcpy(this.buffer, this.index, value.toByteArray(), 0);
            this.index += value.length();
            this.buffer[this.index++] = (byte)TBLTable.convertChar(10, this.xlate);
            rc = this.th.nextTag();
        }
        if (this.th.hasKids()) {
            rc = this.th.firstSection();
            while (rc == 0) {
                rc = this.th.thisSection(name);
                if (rc != 0) {
                    return rc;
                }
                this.appendBuf(name.length() + 10);
                this.buffer[this.index++] = (byte)TBLTable.convertChar(60, this.xlate);
                EcUtil.strcpy(this.buffer, this.index, name.toByteArray(), 0);
                this.index += name.length();
                EcUtil.strcpy(this.buffer, this.index, this.sectionEnd, 0);
                if (this.xlate != null) {
                    EcUtil.convertCharSet(this.buffer, this.index, this.xlate);
                }
                this.index += this.sectionEnd.length;
                rc = this.th.nextSection();
            }
            this.th.parentSection();
        }
        this.appendBuf(1);
        this.buffer[this.index++] = 0;
        int wrote = this.handle.metaLinkWrite(section, 1, this.buffer, 0, this.index, this.codePage | 0x10 | (gateway ? 1 : 0));
        if (wrote == 0) {
            return 33;
        }
        if (this.th.hasKids()) {
            rc = this.th.firstSection();
            while (rc == 0) {
                rc = this.compactSection(false);
                if (rc != 0) {
                    return rc;
                }
                rc = this.th.nextSection();
            }
            this.th.parentSection();
        }
        if ((rc = this.th.getSectionTable(tableArr = new TBLTable[1], true)) != 0) {
            return rc;
        }
        TBLTable master = tableArr[0];
        if (master != null) {
            this.secBuf = new byte[EcUtil.strlen(section, 0) + 7];
            this.secIndex = 0;
            this.secName = section;
            this.nameIndex = 1;
            this.numTab = 0;
            if (this.wantConsolid && (master.tblFlags & 0x400) == 1024 && master.recCount > 0) {
                this.consolidated = true;
                this.pgno = 0;
                this.table = master;
                while (this.table != null) {
                    ++this.numTab;
                    this.table = this.table.nextIndex;
                }
            } else {
                this.consolidated = false;
                this.pgno = 0;
                for (int j = 0; j < this.mapping.length; ++j) {
                    this.mapping[j].brow = 0;
                    this.mapping[j].map = 0;
                }
                this.table = master;
                while (this.table != null) {
                    rc = this.remapPages(this.table.rootOffset);
                    if (rc != 0) {
                        return rc;
                    }
                    ++this.numTab;
                    this.table = this.table.nextIndex;
                }
            }
            this.index = 0;
            this.appendBuf(5);
            this.index += EcUtil.putNumber(this.buffer, this.index, this.pgno);
            this.index += EcUtil.putNumber(this.buffer, this.index, this.numTab);
            EcUtil.strcpy(this.secBuf, this.secIndex, this.secName, this.nameIndex);
            int secLen = EcUtil.strlen(this.secBuf, this.secIndex);
            int ptr = this.secIndex + secLen;
            EcUtil.strcpy(this.secBuf, ptr, this.aBuf, 0);
            if (this.xlate != null) {
                EcUtil.convertCharSet(this.secBuf, ptr, this.xlate);
            }
            if ((wrote = this.handle.metaLinkWrite(this.secBuf, this.secIndex, this.buffer, 0, this.index, this.codePage | 0x10 | 0x400)) == 0) {
                return 33;
            }
            this.numTab = 0;
            this.table = master;
            while (this.table != null) {
                rc = this.compactTable();
                if (rc != 0) {
                    return rc;
                }
                ++this.numTab;
                this.table = this.table.nextIndex;
            }
            if (this.consolidated) {
                rc = this.consolidate(master);
                if (rc != 0) {
                    return rc;
                }
            } else {
                for (i = 0; i < this.pages; ++i) {
                    rc = this.compactPage(i);
                    if (rc == 0) continue;
                    return rc;
                }
            }
            this.index = 0;
            this.appendBuf(5);
            this.index += EcUtil.putNumber(this.buffer, this.index, this.numTab);
            EcUtil.strcpy(this.secBuf, this.secIndex, this.secName, this.nameIndex);
            secLen = EcUtil.strlen(this.secBuf, this.secIndex);
            ptr = this.secIndex + secLen;
            EcUtil.strcpy(this.secBuf, ptr, this.zBuf, 0);
            if (this.xlate != null) {
                EcUtil.convertCharSet(this.secBuf, ptr, this.xlate);
            }
            if ((wrote = this.handle.metaLinkWrite(this.secBuf, this.secIndex, this.buffer, 0, this.index, this.codePage | 0x10 | 0x400)) == 0) {
                return 33;
            }
            master.delete();
            master = null;
            this.secBuf = null;
        }
        section = null;
        return 0;
    }

    int remapPages(int pgoff) {
        if (pgoff == 0) {
            return 0;
        }
        int i = pgoff / this.pgSize;
        TBLPageNumber m = this.mapping[i];
        if (m.brow != 0) {
            return 0;
        }
        int rlen = (this.table.tblFlags & 0x80) == 128 ? this.table.nextIndex.brRowLen : this.table.brRowLen;
        ++this.pgno;
        m.map = this.pgno;
        m.brow = rlen;
        TBLPage pg = this.tblFile.absolutePage(pgoff);
        if (pg.isBranch()) {
            int nrec;
            this.tblFile.holdPage(pg);
            this.remapPages(pg.getPageLower());
            if (pg.mappedBuffer != null) {
                int rec = pg.body;
                for (nrec = pg.getPageRecords(); nrec > 0; --nrec) {
                    this.remapPages((int)TBLTable.getLong(pg.mappedBuffer, rec + rlen - 4));
                    rec += rlen;
                }
            } else {
                int rec = pg.body;
                while (nrec > 0) {
                    this.remapPages((int)TBLTable.getLong(pg.unmappedBuffer, rec + rlen - 4));
                    rec += rlen;
                    --nrec;
                }
            }
            this.tblFile.releasePage(pg);
        } else {
            int back = pg.getPageLower();
            int forward = pg.getPageForward();
            this.remapPages(back);
            this.remapPages(forward);
        }
        return 0;
    }

    int compactTable() {
        int wrote;
        int rc;
        TBLStruct layout;
        this.index = 0;
        this.appendBuf(60);
        long rootOff = this.consolidated ? 1L : (long)this.mapAddress(this.table.rootOffset);
        this.index += EcUtil.putNumber(this.buffer, this.index, rootOff);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.tblType);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.leafRowLen);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.strOff);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.strCount);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.brRowLen);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.keyLen);
        long flags = (long)this.table.tblFlags & 0x178CL;
        if (this.consolidated) {
            flags |= 0x800L;
        }
        this.index += EcUtil.putNumber(this.buffer, this.index, flags);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.strucId);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.recCount);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.numCols);
        this.index += EcUtil.putNumber(this.buffer, this.index, this.table.formLen);
        if ((this.table.tblFlags & 0x1000) == 4096) {
            this.index += EcUtil.putNumber(this.buffer, this.index, this.table.delCount);
        }
        if (this.table.formLen != 0) {
            this.appendBuf(this.table.formLen);
            System.arraycopy(this.table.colForm, 0, this.buffer, this.index, this.table.formLen);
            this.index += this.table.formLen;
        }
        if ((layout = this.table.layout) != null && (rc = this.compactStruct(4, layout)) != 0) {
            return rc;
        }
        EcUtil.strcpy(this.secBuf, this.secIndex, this.secName, this.nameIndex);
        int secLen = EcUtil.strlen(this.secBuf, this.secIndex);
        int ptr = this.secIndex + secLen;
        DomainString str = new DomainString("%D");
        int digits = 1;
        if (this.numTab < 100 && this.numTab >= 10) {
            digits = 0;
        }
        for (int i = 0; i < digits; ++i) {
            str.append("0");
        }
        str.append("" + this.numTab + (this.numTab == 0 ? (char)'G' : 'I'));
        System.arraycopy(str.toByteArray(), 0, this.secBuf, ptr, str.length());
        if (this.xlate != null) {
            EcUtil.convertCharSet(this.secBuf, ptr, this.xlate);
        }
        if ((wrote = this.handle.metaLinkWrite(this.secBuf, this.secIndex, this.buffer, 0, this.index, this.codePage | 0x10 | 0x400)) == 0) {
            return 33;
        }
        return 0;
    }

    int compactPage(int pid) {
        int wrote;
        TBLPageNumber tpn = this.mapping[pid];
        if (tpn.brow == 0) {
            return 0;
        }
        this.index = 0;
        this.appendBuf(5);
        this.index += EcUtil.putNumber(this.buffer, this.index, tpn.brow);
        TBLPage blk = this.tblFile.absolutePage(this.pgSize * pid);
        int rused = blk.getPageRowData() + 16;
        int sused = blk.getPageStrings();
        this.appendBuf(rused);
        if (blk.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, 0, this.buffer, this.index, rused);
        } else {
            System.arraycopy(blk.unmappedBuffer, 0, this.buffer, this.index, rused);
        }
        TBLTable.putShort(this.buffer, this.index, (short)(rused + sused));
        TBLPage newBlk = new TBLPage(this.buffer, this.index);
        newBlk.assignParts(this.index);
        if (newBlk.isBranch()) {
            int pagno = this.mapAddress(newBlk.getPageLower());
            newBlk.setLower(pagno);
            int rlen = tpn.brow;
            int rec = this.index + 16;
            for (int nrec = newBlk.getPageRecords(); nrec > 0; --nrec) {
                pagno = this.mapAddress((int)TBLTable.getLong(this.buffer, rec + rlen - 4));
                TBLTable.putLong(this.buffer, rec + rlen - 4, (long)pagno);
                rec += rlen;
            }
        } else {
            int pagno = newBlk.getPageLower();
            if (pagno != 0) {
                newBlk.setLower(this.mapAddress(pagno));
            }
            if ((pagno = newBlk.getPageForward()) != 0) {
                newBlk.setForward(this.mapAddress(pagno));
            }
        }
        this.index += rused;
        if (sused > 0) {
            int strPtr = blk.offset + (blk.getPageSize() - sused);
            this.appendBuf(sused);
            if (blk.mappedBuffer != null) {
                DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, strPtr, this.buffer, this.index, sused);
            } else {
                System.arraycopy(blk.unmappedBuffer, strPtr, this.buffer, this.index, sused);
            }
            this.index += sused;
        }
        this.appendBuf(4);
        TBLTable.putLong(this.buffer, this.index, (long)tpn.map);
        this.index += 4;
        int nameLen = EcUtil.strlen(this.secName, this.nameIndex);
        EcUtil.strcpy(this.secBuf, this.secIndex, this.secName, this.nameIndex);
        int ptr = this.secIndex + nameLen;
        DomainString str = new DomainString("%P");
        if (tpn.map < 100000) {
            str.append(String.format("%05d", tpn.map));
        } else {
            str.append(String.format("%d", tpn.map));
        }
        System.arraycopy(str.toByteArray(), 0, this.secBuf, ptr, str.length());
        if (this.xlate != null) {
            EcUtil.convertCharSet(this.secBuf, ptr, this.xlate);
        }
        if ((wrote = this.handle.metaLinkWrite(this.secBuf, this.secIndex, this.buffer, 0, this.index, this.codePage | 0x10 | 0x400)) == 0) {
            return 33;
        }
        return 0;
    }

    int consolidate(TBLTable master) {
        int wrote;
        TBLPage blk;
        int rused = 0;
        int recSize = 5 + master.leafRowLen * master.recCount;
        byte[] recBuf = new byte[recSize];
        int recIndex = 0;
        if (recBuf == null) {
            return 33;
        }
        int nextRec = recIndex + EcUtil.putNumber(recBuf, recIndex, master.recCount);
        int paddr = master.rootOffset;
        while (!(blk = master.file.absolutePage(paddr)).isLeaf()) {
            paddr = blk.getPageLower();
        }
        while (true) {
            int nrec;
            if ((rused += (nrec = blk.getPageRecords())) > master.recCount) {
                return 33;
            }
            int recLen = nrec * master.leafRowLen;
            if (blk.mappedBuffer != null) {
                DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, blk.body, recBuf, nextRec, recLen);
            } else {
                System.arraycopy(blk.unmappedBuffer, blk.body, recBuf, nextRec, recLen);
            }
            nextRec += recLen;
            paddr = blk.getPageForward();
            if (paddr == 0) break;
            blk = master.file.absolutePage(paddr);
        }
        EcUtil.strcpy(this.secBuf, this.secIndex, this.secName, this.nameIndex);
        int secLen = EcUtil.strlen(this.secBuf, this.secIndex);
        int ptr = this.secIndex + secLen;
        EcUtil.strcpy(this.secBuf, ptr, this.tBuf, 0);
        if (this.xlate != null) {
            EcUtil.convertCharSet(this.secBuf, ptr, this.xlate);
        }
        if ((wrote = this.handle.metaLinkWrite(this.secBuf, this.secIndex, recBuf, recIndex, recSize, this.codePage | 0x10 | 0x400)) == 0) {
            return 33;
        }
        recBuf = null;
        return 0;
    }

    int mapAddress(int roff) {
        int i = roff / this.pgSize;
        TBLPageNumber tpn = this.mapping[i];
        return tpn.map;
    }

    static class TBLPageNumber {
        int map;
        int brow;

        TBLPageNumber() {
        }
    }
}

