/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLSpace;
import com.mmmhis.domain.table.TBLTable;

public class TBLTree {
    public static final int TBLSAVE_ITEM_SECT = 2;
    public static final int TBLSAVE_SECT_ID = 0;
    public static final int TBLSAVE_SECT_NEXT = 1;
    public static final int TBLSAVE_SECT_PARENT = 5;
    public static final int TBLSAVE_SECT_KIDS = 9;
    public static final int TBLSAVE_SECT_TAGS = 13;
    public static final int TBLSAVE_SECT_TABLE = 17;
    public static final int TBLSAVE_SECT_NAME = 21;
    public static final int TBLSAVE_SECT_RECLEN = 22;
    TBLFile file;
    int curSect;
    int parSect;
    int subSect;
    int nextSect;
    int refSect;
    int refTag;
    int firstTag;
    int tableDef;
    int curTag;
    int nextTag;
    char rootSlash;
    char dot;
    String leftOver;
    byte[] refSectBuf;
    DomainByteArrayFileMap mappedRefSectBuf;
    byte[] refTagBuf;
    DomainByteArrayFileMap mappedRefTagBuf;

    public TBLTree(TBLFile tf) {
        this.file = tf;
        this.curSect = 0;
        this.parSect = 0;
        this.subSect = 0;
        this.nextSect = 0;
        this.refSect = 0;
        this.firstTag = 0;
        this.tableDef = 0;
        this.curTag = 0;
        this.nextTag = 0;
        this.refTag = 0;
        this.refSectBuf = null;
        this.mappedRefSectBuf = null;
        this.refTagBuf = null;
        this.mappedRefTagBuf = null;
        this.leftOver = null;
        this.rootSlash = (char)47;
        this.dot = (char)46;
    }

    public boolean hasKids() {
        if (this.curSect == 0) {
            return false;
        }
        return this.subSect != 0;
    }

    public TBLFile getTblFile() {
        return this.file;
    }

    public boolean loadSection(int off) throws DomainException {
        if (off == 0) {
            return false;
        }
        TBLSpace space = this.file.referSpace(off);
        int sect = space.offset;
        TBLPage sectPage = space.page;
        if (sectPage.mappedBuffer != null) {
            if (sectPage.mappedBuffer.getByte(sect + 0) != 2) {
                throw new DomainException("TBL file corrupted");
            }
            this.curSect = off;
            this.parSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 5);
            this.subSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 9);
            this.nextSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 1);
            this.firstTag = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 13);
            this.tableDef = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 17);
            this.refSect = sect;
            this.mappedRefSectBuf = sectPage.mappedBuffer;
        } else {
            if (sectPage.unmappedBuffer[sect + 0] != 2) {
                throw new DomainException("TBL file corrupted");
            }
            this.curSect = off;
            this.parSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 5);
            this.subSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 9);
            this.nextSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 1);
            this.firstTag = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 13);
            this.tableDef = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 17);
            this.refSect = sect;
            this.refSectBuf = sectPage.unmappedBuffer;
        }
        this.curTag = 0;
        this.nextTag = 0;
        return true;
    }

    public boolean resetSection() throws DomainException {
        return this.loadSection(this.file.getRootOffset());
    }

    public boolean parentSection() throws DomainException {
        return this.loadSection(this.parSect);
    }

    public boolean firstSection() throws DomainException {
        return this.loadSection(this.subSect);
    }

    public boolean nextSection() throws DomainException {
        return this.loadSection(this.nextSect);
    }

    public boolean hasNextSection() {
        return this.nextSect != 0;
    }

    public boolean hasTable() {
        return this.tableDef != 0;
    }

    public boolean prevSection() throws DomainException {
        int target = this.curSect;
        boolean rc = this.loadSection(this.parSect);
        if (!rc) {
            return false;
        }
        rc = this.loadSection(this.subSect);
        while (rc) {
            if (this.curSect == target) {
                return false;
            }
            if (this.nextSect == target) {
                return true;
            }
            rc = this.loadSection(this.nextSect);
        }
        return false;
    }

    public boolean lastSection() throws DomainException {
        boolean rc = this.loadSection(this.parSect);
        if (!rc) {
            return false;
        }
        rc = this.loadSection(this.subSect);
        while (rc) {
            if (this.nextSect == 0) {
                return true;
            }
            rc = this.loadSection(this.nextSect);
        }
        return false;
    }

    public String getSectionName() throws DomainException {
        int begin;
        String pname = null;
        if (this.curSect == 0) {
            throw new DomainException("No current section");
        }
        int end = begin = this.refSect + 21;
        if (this.mappedRefSectBuf != null) {
            while (this.mappedRefSectBuf.getByte(end) != 0) {
                ++end;
            }
            pname = new String(this.mappedRefSectBuf.getBytes(begin, end - begin));
        } else {
            while (this.refSectBuf[end] != 0) {
                ++end;
            }
            pname = new String(this.refSectBuf, begin, end - begin);
        }
        return pname;
    }

    public boolean findSection(String path) throws DomainException {
        this.leftOver = null;
        if (path.length() <= 0 || path.charAt(0) == '\u0000') {
            return false;
        }
        int index = 0;
        char[] buffer = path.toCharArray();
        char[] work = new char[128];
        if (buffer[0] == this.rootSlash) {
            if (!this.loadSection(this.file.getRootOffset())) {
                return false;
            }
            ++index;
        }
        while (index < buffer.length) {
            int workIndex = 0;
            int startSegment = index;
            while (index < buffer.length && buffer[index] != this.rootSlash) {
                char c = buffer[index++];
                work[workIndex++] = Character.toUpperCase(c);
            }
            if (work[0] == '\u0000') {
                throw new DomainException("Bad path:" + path);
            }
            if (work[0] == this.dot) {
                if (work[1] == this.dot && this.parSect != 0) {
                    this.loadSection(this.parSect);
                }
            } else {
                String bufStr;
                int here = this.curSect;
                String workStr = new String(work, 0, workIndex);
                boolean rc = this.loadSection(this.subSect);
                while (rc && !workStr.equals(bufStr = this.getSectionName())) {
                    rc = this.loadSection(this.nextSect);
                }
                if (!rc) {
                    this.loadSection(here);
                    this.leftOver = new String(buffer, startSegment, buffer.length - startSegment);
                    return true;
                }
            }
            if (index >= buffer.length || buffer[index] != this.rootSlash) continue;
            ++index;
        }
        return true;
    }

    public boolean loadTag(int off) throws DomainException {
        if (off == 0) {
            return false;
        }
        TBLSpace space = this.file.referSpace(off);
        this.refTag = space.offset;
        TBLPage tagPage = space.page;
        this.curTag = off;
        if (tagPage.mappedBuffer != null) {
            this.mappedRefTagBuf = tagPage.mappedBuffer;
            this.nextTag = (int)TBLTable.getLong(this.mappedRefTagBuf, this.refTag);
        } else {
            this.refTagBuf = tagPage.unmappedBuffer;
            this.nextTag = (int)TBLTable.getLong(this.refTagBuf, this.refTag);
        }
        return true;
    }

    public String getTagName() throws DomainException {
        int begin;
        String tname = null;
        if (this.curTag == 0) {
            throw new DomainException("No current tag");
        }
        int end = begin = this.refTag + 4;
        if (this.mappedRefTagBuf != null) {
            while (this.mappedRefTagBuf.getByte(end) != 0) {
                ++end;
            }
            tname = new String(this.mappedRefTagBuf.getBytes(begin, end - begin));
        } else {
            while (this.refTagBuf[end] != 0) {
                ++end;
            }
            tname = new String(this.refTagBuf, begin, end - begin);
        }
        return tname;
    }

    public String getTagValue() throws DomainException {
        String tvalue;
        int begin;
        if (this.curTag == 0) {
            throw new DomainException("No current tag");
        }
        int end = begin = this.refTag + 4;
        if (this.mappedRefTagBuf != null) {
            while (this.mappedRefTagBuf.getByte(end) != 0) {
                ++end;
            }
        } else {
            while (this.refTagBuf[end] != 0) {
                ++end;
            }
        }
        end = begin = end + 1;
        if (this.mappedRefTagBuf != null) {
            while (this.mappedRefTagBuf.getByte(end) != 0) {
                ++end;
            }
            tvalue = new String(this.mappedRefTagBuf.getBytes(begin, end - begin));
        } else {
            while (this.refTagBuf[end] != 0) {
                ++end;
            }
            tvalue = new String(this.refTagBuf, begin, end - begin);
        }
        return tvalue;
    }

    public boolean firstTag() throws DomainException {
        return this.loadTag(this.firstTag);
    }

    public boolean nextTag() throws DomainException {
        return this.loadTag(this.nextTag);
    }

    public boolean prevTag() throws DomainException {
        if (this.curTag == 0) {
            throw new DomainException("No current tag");
        }
        int target = this.curTag;
        boolean rc = this.loadTag(this.firstTag);
        while (rc) {
            if (this.curTag == target) {
                return false;
            }
            if (this.nextTag == target) {
                return true;
            }
            rc = this.loadTag(this.nextTag);
        }
        return false;
    }

    public boolean lastTag() throws DomainException {
        boolean rc = this.loadTag(this.firstTag);
        while (rc) {
            if (this.nextTag == 0) {
                return true;
            }
            rc = this.loadTag(this.nextTag);
        }
        return false;
    }

    public boolean findTag(String name) throws DomainException {
        if (name.length() <= 0 || name.charAt(0) == '\u0000') {
            return false;
        }
        if (name.indexOf(this.rootSlash) != -1) {
            if (!this.findSection(name)) {
                return false;
            }
            if (this.leftOver.indexOf(this.rootSlash) != -1) {
                return false;
            }
            name = this.leftOver;
        }
        char[] work = new char[name.length()];
        for (int index = 0; index < name.length(); ++index) {
            work[index] = Character.toUpperCase(name.charAt(index));
        }
        String workStr = new String(work, 0, name.length());
        int here = this.curTag;
        boolean rc = this.loadTag(this.firstTag);
        while (rc) {
            String tagStr = this.getTagName();
            if (workStr.equals(tagStr)) {
                return true;
            }
            rc = this.loadTag(this.nextTag);
        }
        if (here != 0) {
            this.loadTag(here);
        }
        return false;
    }

    public TBLTable loadTable(String path) throws DomainException {
        if (path != null) {
            this.findSection(path);
        }
        if (this.tableDef <= 0) {
            throw new DomainException("No table in current section");
        }
        return new TBLTable(this.file, this.tableDef);
    }
}

