/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.td;

import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBFile;
import com.mmmhis.domain.td.TDTag;
import java.io.IOException;
import java.io.Writer;

public final class TDSection {
    public static final String ROOT_SECTION_NAME = "Root";
    TDSection parent;
    TDSection next;
    TDSection kids;
    TDTag tags;
    int userData;
    String name;

    public TDSection(String name) {
        this.name = name.toUpperCase();
    }

    public TDSection getParent() {
        return this.parent;
    }

    public void setParent(TDSection section) {
        this.parent = section;
    }

    public TDSection getNext() {
        return this.next;
    }

    public void setNext(TDSection section) {
        this.next = section;
    }

    public TDSection getKids() {
        return this.kids;
    }

    public void setKids(TDSection section) {
        this.kids = section;
    }

    public TDTag getTags() {
        return this.tags;
    }

    public void setTags(TDTag tag) {
        this.tags = tag;
    }

    public int getUserData() {
        return this.userData;
    }

    public void setUserData(int data) {
        this.userData = data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public int delete() {
        if (this.parent != null) {
            this.remove();
        }
        this.clear();
        return 0;
    }

    public int add(TDTag tag) {
        if (this.tags == null) {
            this.tags = tag;
        } else {
            this.last().next = tag;
        }
        tag.parent = this;
        return 0;
    }

    public int add(TDSection section) {
        if (this.kids == null) {
            this.kids = section;
        } else {
            TDSection.last((TDSection)this.kids).next = section;
        }
        section.parent = this;
        return 0;
    }

    public int insert(TDSection section) {
        if (this.parent == null) {
            return 108;
        }
        section.next = this;
        section.parent = this.parent;
        TDSection prev = this.prev();
        if (prev != null) {
            prev.next = section;
        } else {
            this.parent.kids = section;
        }
        return 0;
    }

    public int remove() {
        TDSection prev = this.prev();
        if (prev != null) {
            prev.next = this.next;
        } else {
            this.parent.kids = this.next;
        }
        this.next = null;
        this.parent = null;
        return 0;
    }

    public int clear() {
        this.tags = null;
        this.kids = null;
        return 0;
    }

    public TDSection prev() {
        if (this.parent == null) {
            return null;
        }
        TDSection curr = this.parent.kids;
        if (curr == this) {
            return null;
        }
        while (curr != null && curr.next != this) {
            curr = curr.next;
        }
        return curr;
    }

    public TDTag findTag(String name) {
        return this.tags != null ? this.tags.findPrimitive(name) : null;
    }

    public TDSection findSection(String name) {
        return TDSection.findPrimitiveSection(this.kids, name);
    }

    protected static TDSection findPrimitiveSection(TDSection section, String sectionName) {
        while (section != null && !section.getName().equals(sectionName)) {
            section = section.getNext();
        }
        return section;
    }

    protected TDSection findPrimitive(String sectionName) {
        TDSection section = this;
        while (section != null && !section.name.equals(sectionName)) {
            section = section.next;
        }
        return section;
    }

    public TDTag last() {
        TDTag tag = this.tags;
        while (tag.next != null) {
            tag = tag.next;
        }
        return tag;
    }

    public static TDSection last(TDSection section) {
        while (section.next != null) {
            section = section.next;
        }
        return section;
    }

    public String getPathName(DomainString pathNameBuffer, int maxBufferSize) {
        String returnPtr;
        if (this.parent != null) {
            returnPtr = this.parent.getPathName(pathNameBuffer, maxBufferSize);
            if (returnPtr != null) {
                if (pathNameBuffer.length() + "/".length() + this.name.length() + 1 < maxBufferSize) {
                    pathNameBuffer.append("/");
                    pathNameBuffer.append(this.name);
                    returnPtr = pathNameBuffer.toString();
                } else {
                    returnPtr = null;
                }
            }
        } else {
            returnPtr = pathNameBuffer.toString();
        }
        return returnPtr;
    }

    public TDSection findPrev(String sectionName) {
        TDSection currSection = this;
        while ((currSection = currSection.prev()) != null && !currSection.name.equals(sectionName)) {
        }
        return currSection;
    }

    public void dumpData(Writer writer, int tab) throws IOException {
        int i;
        TDTag tag = this.tags;
        while (tag != null) {
            for (i = 0; i < tab; ++i) {
                writer.write(" ");
            }
            writer.write(tag.getName() + "=" + tag.getValue() + "\n");
            tag = tag.next;
        }
        TDSection kid = this.kids;
        while (kid != null) {
            for (i = 0; i < tab; ++i) {
                writer.write(" ");
            }
            writer.write("<" + kid.getName() + ">\n");
            kid.dumpData(writer, tab + 4);
            for (i = 0; i < tab; ++i) {
                writer.write(" ");
            }
            writer.write("<END>\n");
            kid = kid.next;
        }
    }

    public int sharedOpenFiles(DBControl dbControl) throws DomainException {
        this.close(dbControl);
        return this.open(dbControl, false);
    }

    public int sharedCloseFiles(DBControl dbControl) throws DomainException {
        int index = this.getUserData();
        while (index != 0) {
            DBFile dptr = dbControl.getFile(index);
            if (dptr.isOpen()) {
                dptr.close(false);
            }
            index = dptr.getSibling();
        }
        return 0;
    }

    public void close(DBControl dbControl) throws DomainException {
        for (TDSection curr = this.getParent().getKids(); curr != null; curr = curr.getNext()) {
            if (curr == this) continue;
            curr.sharedCloseFiles(dbControl);
        }
    }

    public int fileCount(DBControl dbControl) throws DomainException {
        int count = 0;
        for (TDTag tag = this.getTags(); tag != null; tag = tag.getNext()) {
            if (tag.getName().equals("LPATH")) {
                String local = tag.getValue();
                TDTag[] tags = new TDTag[1];
                int status = dbControl.getTDHandle().findTag(local, tags);
                if (status == 0) {
                    tag.setName("PATH");
                    tag.setValue(tags[0].getValue());
                }
            }
            if (!tag.getName().equals("PATH")) continue;
            ++count;
            if (tag.getValue() != null) continue;
            throw new DomainException(1287);
        }
        for (TDSection section = this.getKids(); section != null; section = section.getNext()) {
            count += section.fileCount(dbControl);
        }
        return count;
    }

    public void fileListBuild(DBControl dbControl, int[] index) {
        DBFile dbFile = null;
        DBFile oldDbFile = null;
        int[] sibling = null;
        String[] arg = new String[1];
        boolean count = false;
        for (TDTag tag = this.getTags(); tag != null; tag = tag.getNext()) {
            if (!tag.getName().equals("PATH")) continue;
            dbFile = dbControl.getFile(index[0]);
            dbFile.setName(dbControl.resolvePathName(tag.getValue(), false, arg));
            if (dbControl.getMemMapped() == 2) {
                dbFile.setInMemory(2);
            }
            if (dbFile.getInMemory() == 0 && dbControl.getMemLoad() == 2) {
                dbFile.setInMemory(1);
            }
            if (arg[0] != null) {
                if (arg[0].toLowerCase().equals("memload") && dbControl.getMemLoad() == 1) {
                    dbFile.setInMemory(1);
                }
                if (arg[0].toLowerCase().equals("memmap") && dbControl.getMemMapped() == 1) {
                    dbFile.setInMemory(2);
                }
            }
            dbFile.setTblCachePages(dbControl.getTblCachePages());
            if (sibling == null) {
                this.setUserData(index[0]);
                sibling = new int[1];
            } else {
                oldDbFile.setSibling(index[0]);
            }
            oldDbFile = dbFile;
            sibling[0] = dbFile.getSibling();
            index[0] = index[0] + 1;
        }
        for (TDSection section = this.getKids(); section != null; section = section.getNext()) {
            section.fileListBuild(dbControl, index);
        }
    }

    public int open(DBControl dbControl, boolean failOnError) throws DomainException {
        int index = this.getUserData();
        int rc = 0;
        while (index != 0) {
            DBFile dbFile = dbControl.getFile(index);
            if (!dbFile.isOpen() && (rc = dbFile.open(dbControl)) == 120) {
                if (failOnError) {
                    throw new DomainException(1281, new Object[]{dbFile.getName()});
                }
                dbControl.setErrorCode(rc);
                int cindex = this.getUserData();
                while (cindex != index) {
                    dbFile = dbControl.getFile(cindex);
                    dbFile.close(false);
                    cindex = dbFile.getSibling();
                }
                break;
            }
            index = dbFile.getSibling();
        }
        return rc;
    }
}

