/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.td;

import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.td.TDSection;

public final class TDTag {
    TDTag next;
    TDSection parent;
    String value;
    String name;

    public TDTag(String name, String value) {
        this.name = name.toUpperCase();
        this.value = value;
    }

    public TDTag getNext() {
        return this.next;
    }

    public void setNext(TDTag tag) {
        this.next = tag;
    }

    public TDSection getParent() {
        return this.parent;
    }

    public void setParent(TDSection section) {
        this.parent = section;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public int delete() {
        int status = 0;
        if (this.parent != null) {
            status = this.remove();
        }
        return status;
    }

    public int insert(TDTag tag) {
        TDTag prev = this.prev();
        tag.parent = this.parent;
        tag.next = this;
        if (prev != null) {
            prev.next = tag;
        } else {
            this.parent.tags = tag;
        }
        return 0;
    }

    public int remove() {
        TDTag prev = this.prev();
        if (prev != null) {
            prev.next = this.next;
        } else {
            this.parent.tags = this.next;
        }
        this.next = null;
        this.parent = null;
        return 0;
    }

    public TDTag last() {
        TDTag tag = this;
        while (tag.next != null) {
            tag = tag.next;
        }
        return tag;
    }

    public TDTag prev() {
        TDTag curr = this.parent.tags;
        while (curr != null && curr.next != this) {
            curr = curr.next;
        }
        return curr;
    }

    protected TDTag findPrimitive(String tagName) {
        TDTag tag = this;
        while (tag != null && !tag.name.equals(tagName)) {
            tag = tag.next;
        }
        return tag;
    }

    public TDTag resetNameValue(String newName, String newValue) {
        TDTag newTag = new TDTag(newName, newValue);
        this.insert(newTag);
        this.delete();
        return newTag;
    }

    public TDTag findPrev(String tagName) {
        TDTag currTag = this;
        while ((currTag = currTag.prev()) != null && !currTag.name.equals(tagName)) {
        }
        return currTag;
    }

    public String getPathName(DomainString pathNameBuffer, int maxBufferSize) {
        String returnPtr = this.parent.getPathName(pathNameBuffer, maxBufferSize);
        if (returnPtr != null) {
            if (pathNameBuffer.length() + "/".length() + this.name.length() + 1 < maxBufferSize) {
                pathNameBuffer.append("/");
                pathNameBuffer.append(this.name);
                returnPtr = pathNameBuffer.toString();
            } else {
                returnPtr = null;
            }
        }
        return returnPtr;
    }
}

