/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.util;

import java.util.Arrays;

public class DomainUtil {
    DomainUtil() {
    }

    public static String strPad(String src, int len, char pad) {
        if (src == null) {
            char[] padded = new char[len];
            Arrays.fill(padded, pad);
            return new String(padded);
        }
        int slen = src.length();
        if (slen == len) {
            return src;
        }
        if (slen > len) {
            return src.substring(0, len);
        }
        char[] padded = new char[len];
        src.getChars(0, slen, padded, 0);
        Arrays.fill(padded, slen, len, pad);
        return new String(padded);
    }

    public static String trimRight(String istr, String rend) {
        String ostr = istr;
        int rlen = rend.length();
        while (ostr.endsWith(rend)) {
            int nlen = ostr.length() - rlen;
            ostr = ostr.substring(0, nlen);
        }
        return ostr;
    }

    public static String strProper(String istr) {
        String lstr = istr.toLowerCase();
        char[] chrs = new char[lstr.length()];
        lstr.getChars(0, lstr.length(), chrs, 0);
        chrs[0] = Character.toUpperCase(chrs[0]);
        return new String(chrs);
    }

    public static String strUptoParens(String istr) {
        int pos = istr.indexOf(40);
        if (pos < 0) {
            return istr;
        }
        return istr.substring(0, pos);
    }

    public static void appendSep(StringBuffer sb, String toadd, String sep) {
        if (sb.length() != 0) {
            sb.append(sep);
        }
        sb.append(toadd);
    }

    public static String formatNumber(int value, int dpoint) {
        String pre_dp = null;
        String post_dp = null;
        String digits = String.valueOf(value);
        int len = digits.length();
        if (dpoint == 0) {
            pre_dp = digits;
        } else if (len < dpoint) {
            pre_dp = "0";
            post_dp = DomainUtil.strPad(null, dpoint - len, '0') + digits;
        } else if (len > dpoint) {
            int afdp = len - dpoint;
            pre_dp = digits.substring(0, afdp);
            post_dp = digits.substring(afdp);
        } else {
            pre_dp = "0";
            post_dp = digits;
        }
        if (pre_dp.length() > 3) {
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (int i = pre_dp.length() - 1; i >= 0; --i) {
                if (count > 0 && count % 3 == 0) {
                    sb.append(',');
                }
                sb.append(pre_dp.charAt(i));
                ++count;
            }
            pre_dp = sb.reverse().toString();
        }
        if (post_dp == null) {
            return pre_dp;
        }
        return pre_dp + "." + post_dp;
    }

    public static int makeInteger(String arg) {
        if (arg == null) {
            return 0;
        }
        if (arg.length() <= 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            n = 10 * n + (c - 48);
        }
        return n;
    }

    public static String commonPart(String low_part, String high_part) {
        char hc;
        char lc;
        int len = low_part.length();
        int i = high_part.length();
        if (i < len) {
            len = i;
        }
        for (i = 0; i < len && (lc = low_part.charAt(i)) == (hc = high_part.charAt(i)); ++i) {
        }
        if (i > 0) {
            return low_part.substring(0, i);
        }
        return null;
    }

    public static String[] decodeDelimited(String line, int nfields, char comma, char quote) {
        String[] field = new String[nfields];
        int i = 0;
        int fnum = 0;
        int len = line.length();
        while (i < len) {
            StringBuilder sb;
            char c = line.charAt(i);
            if (c == ' ') {
                ++i;
                continue;
            }
            if (c == quote) {
                sb = new StringBuilder();
                ++i;
                while (i < len && (c = line.charAt(i)) != quote) {
                    sb.append(c);
                    ++i;
                }
                field[fnum++] = sb.toString();
                if (i < len && c == quote) {
                    ++i;
                    while (i < len && (c = line.charAt(i)) == ' ') {
                        ++i;
                    }
                    if (i < len && c == comma) {
                        ++i;
                    }
                }
            } else {
                sb = new StringBuilder();
                while (i < len && (c = line.charAt(i)) != comma) {
                    sb.append(c);
                    ++i;
                }
                field[fnum++] = sb.toString();
                if (i < len && c == comma) {
                    ++i;
                }
            }
            if (fnum < nfields) continue;
            return field;
        }
        while (fnum < nfields) {
            field[fnum++] = null;
        }
        return field;
    }

    public static String emDash(String text) {
        StringBuilder sb = new StringBuilder();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '_') {
                sb.append(' ');
                continue;
            }
            char k = c;
            if (!(k != '\u00c2' && k != '\u00e2' || i + 2 >= len || (k = text.charAt(i + 1)) != '\u0080' || (k = text.charAt(i + 2)) != '\u0093' && k != '\u0094')) {
                sb.append('-');
                i += 2;
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public static String getPlurality(int count, String msg) {
        int pos = msg.indexOf(63);
        if (pos < 0) {
            return msg;
        }
        String before = msg.substring(0, pos);
        String after = msg.substring(pos + 1);
        if (count == 1) {
            return before + after;
        }
        return before + "s" + after;
    }

    public static char[] zeroFill(int x, int length) {
        char[] digits = new char[length];
        int rest = x;
        for (int i = length - 1; i >= 0; --i) {
            digits[i] = (char)(rest % 10 + 48);
            rest /= 10;
        }
        return digits;
    }
}

