/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.api;

import gov.cms.oce.dao.dsc.DescriptionDaoFactory;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.internal.OceClaimProcessor;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimExecutor.class);
    private final ClaimProcessor claimProcessor = new OceClaimProcessor();

    public final void processClaim(OceClaim oceClaim) {
        if (logger.isDebugEnabled()) {
            logger.debug("Processing Claim \"{}\"", (Object)oceClaim.getProcessingInformation().getClaimId());
        }
        boolean success = !this.claimProcessor.process(oceClaim);
        Integer returnCode = oceClaim.getProcessingInformation().getReturnCode();
        if (returnCode == null) {
            logger.error("Return null return code.");
        } else if (returnCode == 0) {
            if (success) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Zero return code value \"{}\" generated by successfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
                }
            } else {
                logger.error("Zero return code value \"{}\" generated by unsuccessfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
            }
        } else if (success) {
            logger.error("Non-zero return code value \"{}\" generated by successfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
        } else if (logger.isWarnEnabled()) {
            logger.warn("Non-zero return code value \"{}\" generated by unsuccessfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
        }
    }

    public final String getApcDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getApcDescription(OceLineItem line, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getDescription(line.getPaymentApc(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestApcDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestApcDescription(OceLineItem line) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getLatestDescription(line.getPaymentApc());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimDispositionDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimDispositionDescription(OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getDescription(claim.getClaimDisposition(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimDispositionDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimDispositionDescription(OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getLatestDescription(claim.getClaimDisposition());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimDispositionValueDescription(String claimDispositionId, String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getDescription(claimDispositionId, value, version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimDispositionValueDescription(String claimDispositionId, OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getDescription(claimDispositionId, claim.getClaimDisposition(), version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimDispositionValueDescription(String claimDispositionId, String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getLatestDescription(claimDispositionId, value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimDispositionValueDescription(String claimDispositionId, OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getLatestDescription(claimDispositionId, claim.getClaimDisposition());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimProcessedFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getClaimProcessedFlagDescription(OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getDescription(claim.getClaimProcessedFlag(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimProcessedFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestClaimProcessedFlagDescription(OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getLatestDescription(claim.getClaimProcessedFlag());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getDiscountFormulaDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getDiscountFormulaDescription(OceLineItem line, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getDescription(line.getDiscountingFormula(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestDiscountFormulaDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestDiscountFormulaDescription(OceLineItem line) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getLatestDescription(line.getDiscountingFormula());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getDiagnosisDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDx10Dao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestDiagnosisDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDx10Dao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getEditDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestEditDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getEditDispositionDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDispositionDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestEditDispositionDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDispositionDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getErrorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscErrorDao().getDescription(value, version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestErrorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscErrorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getHcpcsDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscHcpcsDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestHcpcsDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscHcpcsDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLineItemActionFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLiafDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestLineItemActionFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLiafDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLineItemDenialRejectionFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLidrfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestLineItemDenialRejectionFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLidrfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getModifierDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscModifierDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestModifierDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscModifierDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getPaymentAdjustmentFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPafDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestPaymentAdjustmentFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPafDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getPaymentIndicatorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPaymentIndicatorDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestPaymentIndicatorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPaymentIndicatorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getPackagingFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPkgDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestPackagingFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPkgDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getPaymentMethodFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPmfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestPaymentMethodFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPmfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getRevenueCodeDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscRevenueDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestRevenueCodeDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscRevenueDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getStatusIndicatorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscStatusIndicatorDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestStatusIndicatorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscStatusIndicatorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getValueCodeDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscValueCodeDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final String getLatestValueCodeDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscValueCodeDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }
}

