/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary;

import gov.cms.oce.dao.DataProvider;
import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.desc.row.DscApcRowInternal;
import gov.cms.oce.dao.desc.row.DscClaimDispositionRowInternal;
import gov.cms.oce.dao.desc.row.DscClaimDispositionValueRowInternal;
import gov.cms.oce.dao.desc.row.DscCpfRowInternal;
import gov.cms.oce.dao.desc.row.DscDiscountFormulaRowInternal;
import gov.cms.oce.dao.desc.row.DscDx10RowInternal;
import gov.cms.oce.dao.desc.row.DscEditDispositionRowInternal;
import gov.cms.oce.dao.desc.row.DscEditRowInternal;
import gov.cms.oce.dao.desc.row.DscErrorRowInternal;
import gov.cms.oce.dao.desc.row.DscHcpcsRowInternal;
import gov.cms.oce.dao.desc.row.DscLiafRowInternal;
import gov.cms.oce.dao.desc.row.DscLidrfRowInternal;
import gov.cms.oce.dao.desc.row.DscModifierRowInternal;
import gov.cms.oce.dao.desc.row.DscPafRowInternal;
import gov.cms.oce.dao.desc.row.DscPaymentIndicatorRowInternal;
import gov.cms.oce.dao.desc.row.DscPkgRowInternal;
import gov.cms.oce.dao.desc.row.DscPmfRowInternal;
import gov.cms.oce.dao.desc.row.DscRevenueRowInternal;
import gov.cms.oce.dao.desc.row.DscStatusIndicatorRowInternal;
import gov.cms.oce.dao.desc.row.DscValueCodeRowInternal;
import gov.cms.oce.dao.desc.table.DscApcTableInternal;
import gov.cms.oce.dao.desc.table.DscClaimDispositionTableInternal;
import gov.cms.oce.dao.desc.table.DscClaimDispositionValueTableInternal;
import gov.cms.oce.dao.desc.table.DscCpfTableInternal;
import gov.cms.oce.dao.desc.table.DscDiscountFormulaTableInternal;
import gov.cms.oce.dao.desc.table.DscDx10TableInternal;
import gov.cms.oce.dao.desc.table.DscEditDispositionTableInternal;
import gov.cms.oce.dao.desc.table.DscEditTableInternal;
import gov.cms.oce.dao.desc.table.DscErrorTableInternal;
import gov.cms.oce.dao.desc.table.DscHcpcsTableInternal;
import gov.cms.oce.dao.desc.table.DscLiafTableInternal;
import gov.cms.oce.dao.desc.table.DscLidrfTableInternal;
import gov.cms.oce.dao.desc.table.DscModifierTableInternal;
import gov.cms.oce.dao.desc.table.DscPafTableInternal;
import gov.cms.oce.dao.desc.table.DscPaymentIndicatorTableInternal;
import gov.cms.oce.dao.desc.table.DscPkgTableInternal;
import gov.cms.oce.dao.desc.table.DscPmfTableInternal;
import gov.cms.oce.dao.desc.table.DscRevenueTableInternal;
import gov.cms.oce.dao.desc.table.DscStatusIndicatorTableInternal;
import gov.cms.oce.dao.desc.table.DscValueCodeTableInternal;
import gov.cms.oce.ext.table.data.DataApcRow;
import gov.cms.oce.ext.table.data.DataDiscountFormulaRow;
import gov.cms.oce.ext.table.data.DataDx10Row;
import gov.cms.oce.ext.table.data.DataHcpcsRow;
import gov.cms.oce.ext.table.data.DataModifierRow;
import gov.cms.oce.ext.table.data.DataRevenueRow;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscClaimDispositionRow;
import gov.cms.oce.ext.table.desc.DscClaimDispositionValueRow;
import gov.cms.oce.ext.table.desc.DscCpfRow;
import gov.cms.oce.ext.table.desc.DscEditDispositionRow;
import gov.cms.oce.ext.table.desc.DscEditRow;
import gov.cms.oce.ext.table.desc.DscErrorRow;
import gov.cms.oce.ext.table.desc.DscLiafRow;
import gov.cms.oce.ext.table.desc.DscLidrfRow;
import gov.cms.oce.ext.table.desc.DscPafRow;
import gov.cms.oce.ext.table.desc.DscPaymentIndicatorRow;
import gov.cms.oce.ext.table.desc.DscPkgRow;
import gov.cms.oce.ext.table.desc.DscPmfRow;
import gov.cms.oce.ext.table.desc.DscStatusIndicatorRow;
import gov.cms.oce.ext.table.desc.DscValueCodeRow;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinaryDescriptionProvider
implements DataProvider {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDescriptionProvider.class);
    private static BinaryDescriptionProvider dataProvider;
    private DscApcTableInternal dscApcTable;
    private DscDiscountFormulaTableInternal dscDiscountFormulaTable;
    private DscDx10TableInternal dscDx10Table;
    private DscHcpcsTableInternal dscHcpcsTable;
    private DscModifierTableInternal dscModifierTable;
    private DscRevenueTableInternal dscRevenueTable;
    private DscClaimDispositionTableInternal dscClaimDispositionTable;
    private DscClaimDispositionValueTableInternal dscClaimDispositionValueTable;
    private DscCpfTableInternal dscCpfTable;
    private DscEditDispositionTableInternal dscEditDispositionTable;
    private DscEditTableInternal dscEditTable;
    private DscErrorTableInternal dscErrorTable;
    private DscLiafTableInternal dscLiafTable;
    private DscLidrfTableInternal dscLidrfTable;
    private DscPafTableInternal dscPafTable;
    private DscPaymentIndicatorTableInternal dscPaymentIndicatorTable;
    private DscPkgTableInternal dscPkgTable;
    private DscPmfTableInternal dscPmfTable;
    private DscStatusIndicatorTableInternal dscStatusIndicatorTable;
    private DscValueCodeTableInternal dscValueCodeTable;
    private final FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);

    private BinaryDescriptionProvider() {
        if (dataProvider != null) {
            throw new IllegalStateException("Illegal instantiation of class");
        }
    }

    public static final synchronized BinaryDescriptionProvider getInstance() {
        if (dataProvider == null || BinaryDescriptionProvider.dataProvider.flags.isNotSet(TableFlags.INITIALIZATION_SUCCESSFUL)) {
            dataProvider = new BinaryDescriptionProvider();
            dataProvider.initialize();
        }
        return dataProvider;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    private final void initialize() {
        Throwable throwable;
        InputStream inputStream;
        try {
            inputStream = BinaryDescriptionProvider.class.getResourceAsStream("/ioce-data.bin");
            throwable = null;
            try {
                DataSchema dataSchema = DataSchema.parseFrom(inputStream);
                this.loadDscApcTable(dataSchema);
                this.loadDscDiscountFormulaTable(dataSchema);
                this.loadDscDx10Table(dataSchema);
                this.loadDscHcpcsTable(dataSchema);
                this.loadDscModifierTable(dataSchema);
                this.loadDscRevenueTable(dataSchema);
            }
            catch (Throwable dataSchema) {
                throwable = dataSchema;
                throw dataSchema;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable dataSchema) {
                            throwable.addSuppressed(dataSchema);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to load table data", e);
        }
        try {
            inputStream = BinaryDescriptionProvider.class.getResourceAsStream("/ioce-desc.bin");
            throwable = null;
            try {
                DescriptionSchema descriptionSchema = DescriptionSchema.parseFrom(inputStream);
                this.loadDscClaimDispositionTable(descriptionSchema);
                this.loadDscClaimDispositionValueTable(descriptionSchema);
                this.loadDscCpfTable(descriptionSchema);
                this.loadDscEditDispositionTable(descriptionSchema);
                this.loadDscEditTable(descriptionSchema);
                this.loadDscErrorTable(descriptionSchema);
                this.loadDscLiafTable(descriptionSchema);
                this.loadDscLidrfTable(descriptionSchema);
                this.loadDscPafTable(descriptionSchema);
                this.loadDscPaymentIndicatorTable(descriptionSchema);
                this.loadDscPkgTable(descriptionSchema);
                this.loadDscPmfTable(descriptionSchema);
                this.loadDscStatusIndicatorTable(descriptionSchema);
                this.loadDscValueCodeTable(descriptionSchema);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to load table data", e);
        }
        if (this.isInitialized()) {
            logger.info("Table initialization succeeded.");
            this.flags.set(TableFlags.INITIALIZATION_SUCCESSFUL);
        } else {
            logger.error("Table initialization failed.");
        }
    }

    public final synchronized boolean isInitialized() {
        return this.dscClaimDispositionTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscClaimDispositionValueTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscCpfTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscEditDispositionTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscEditTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscErrorTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscLiafTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscLidrfTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscPafTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscPaymentIndicatorTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscPkgTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscPmfTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscStatusIndicatorTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dscValueCodeTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final int getCapacityEstimate(int collectionSize) {
        return (int)Math.ceil((double)collectionSize * 0.3);
    }

    private final void loadDscApcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataApcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataApcRow row : data.getDataApcTable().getRowList()) {
            Map<DscApcTableInternal.DscApcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscApcTableInternal.DscApcTableKey.class);
            tableKey.put(DscApcTableInternal.DscApcTableKey.APC, row.getApc());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscApcRowInternal(row.getApc(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscApcTable = new DscApcTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscApcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscDiscountFormulaTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataDiscountFormulaTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataDiscountFormulaRow row : data.getDataDiscountFormulaTable().getRowList()) {
            Map<DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.class);
            tableKey.put(DscDiscountFormulaTableInternal.DscDiscountFormulaTableKey.DISCOUNT_KEY, row.getDiscountKey());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscDiscountFormulaRowInternal(row.getDiscountKey(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscDiscountFormulaTable = new DscDiscountFormulaTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscDiscountFormulaTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscDx10Table(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataDx10Table().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataDx10Row row : data.getDataDx10Table().getRowList()) {
            Map<DscDx10TableInternal.DscDx10TableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscDx10TableInternal.DscDx10TableKey.class);
            tableKey.put(DscDx10TableInternal.DscDx10TableKey.DIAGNOSIS, row.getDiagnosis());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscDx10RowInternal(row.getDiagnosis(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscDx10Table = new DscDx10TableInternal(Collections.unmodifiableMap(finalTable));
        this.dscDx10Table.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscHcpcsTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataHcpcsTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataHcpcsRow row : data.getDataHcpcsTable().getRowList()) {
            Map<DscHcpcsTableInternal.DscHcpcsTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscHcpcsTableInternal.DscHcpcsTableKey.class);
            tableKey.put(DscHcpcsTableInternal.DscHcpcsTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscHcpcsRowInternal(row.getHcpcs(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscHcpcsTable = new DscHcpcsTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscHcpcsTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscModifierTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataModifierTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataModifierRow row : data.getDataModifierTable().getRowList()) {
            Map<DscModifierTableInternal.DscModifierTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscModifierTableInternal.DscModifierTableKey.class);
            tableKey.put(DscModifierTableInternal.DscModifierTableKey.MODIFIER, row.getModifier());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscModifierRowInternal(row.getModifier(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscModifierTable = new DscModifierTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscModifierTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscRevenueTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataRevenueTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataRevenueRow row : data.getDataRevenueTable().getRowList()) {
            Map<DscRevenueTableInternal.DscRevenueTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscRevenueTableInternal.DscRevenueTableKey.class);
            tableKey.put(DscRevenueTableInternal.DscRevenueTableKey.REVENUE_CODE, String.valueOf(row.getRevenueCode()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscRevenueRowInternal((short)row.getRevenueCode(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscRevenueTable = new DscRevenueTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscRevenueTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscClaimDispositionTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscClaimDispositionTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscClaimDispositionRow row : data.getDscClaimDispositionTable().getRowList()) {
            Map<DscClaimDispositionTableInternal.DscClaimDispositionTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.class);
            tableKey.put(DscClaimDispositionTableInternal.DscClaimDispositionTableKey.ID, String.valueOf(row.getId()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscClaimDispositionRowInternal((byte)row.getId(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getAbbreviation(), row.getName(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscClaimDispositionTable = new DscClaimDispositionTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscClaimDispositionTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscClaimDispositionValueTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscClaimDispositionValueTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscClaimDispositionValueRow row : data.getDscClaimDispositionValueTable().getRowList()) {
            Map<DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.class);
            tableKey.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.CLAIM_DISPOSITION_ID, String.valueOf(row.getClaimDispositionId()));
            tableKey.put(DscClaimDispositionValueTableInternal.DscClaimDispositionValueTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscClaimDispositionValueRowInternal((byte)row.getClaimDispositionId(), (byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscClaimDispositionValueTable = new DscClaimDispositionValueTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscClaimDispositionValueTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscCpfTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscCpfTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscCpfRow row : data.getDscCpfTable().getRowList()) {
            Map<DscCpfTableInternal.DscCpfTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscCpfTableInternal.DscCpfTableKey.class);
            tableKey.put(DscCpfTableInternal.DscCpfTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscCpfRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscCpfTable = new DscCpfTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscCpfTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscEditTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscEditTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscEditRow row : data.getDscEditTable().getRowList()) {
            Map<DscEditTableInternal.DscEditTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscEditTableInternal.DscEditTableKey.class);
            tableKey.put(DscEditTableInternal.DscEditTableKey.EDIT, String.valueOf(row.getEdit()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscEditRowInternal((short)row.getEdit(), (short)row.getLoVersion(), (short)row.getHiVersion(), (byte)row.getDispositionId(), row.getBuffer(), row.getName(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscEditTable = new DscEditTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscEditTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscEditDispositionTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscEditDispositionTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscEditDispositionRow row : data.getDscEditDispositionTable().getRowList()) {
            Map<DscEditDispositionTableInternal.DscEditDispositionTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscEditDispositionTableInternal.DscEditDispositionTableKey.class);
            tableKey.put(DscEditDispositionTableInternal.DscEditDispositionTableKey.ID, String.valueOf(row.getId()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscEditDispositionRowInternal((byte)row.getId(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getAbbreviation(), row.getName(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscEditDispositionTable = new DscEditDispositionTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscEditDispositionTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscErrorTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscErrorTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscErrorRow row : data.getDscErrorTable().getRowList()) {
            Map<DscErrorTableInternal.DscErrorTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscErrorTableInternal.DscErrorTableKey.class);
            tableKey.put(DscErrorTableInternal.DscErrorTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscErrorRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscErrorTable = new DscErrorTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscErrorTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscLiafTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscLiafTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscLiafRow row : data.getDscLiafTable().getRowList()) {
            Map<DscLiafTableInternal.DscLiafTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscLiafTableInternal.DscLiafTableKey.class);
            tableKey.put(DscLiafTableInternal.DscLiafTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscLiafRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscLiafTable = new DscLiafTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscLiafTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscLidrfTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscLidrfTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscLidrfRow row : data.getDscLidrfTable().getRowList()) {
            Map<DscLidrfTableInternal.DscLidrfTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscLidrfTableInternal.DscLidrfTableKey.class);
            tableKey.put(DscLidrfTableInternal.DscLidrfTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscLidrfRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscLidrfTable = new DscLidrfTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscLidrfTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscPafTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscPafTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscPafRow row : data.getDscPafTable().getRowList()) {
            Map<DscPafTableInternal.DscPafTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscPafTableInternal.DscPafTableKey.class);
            tableKey.put(DscPafTableInternal.DscPafTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscPafRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscPafTable = new DscPafTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscPafTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscPaymentIndicatorTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscPaymentIndicatorTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscPaymentIndicatorRow row : data.getDscPaymentIndicatorTable().getRowList()) {
            Map<DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.class);
            tableKey.put(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.PAYMENT_INDICATOR, String.valueOf(row.getPaymentIndicator()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscPaymentIndicatorRowInternal((byte)row.getPaymentIndicator(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscPaymentIndicatorTable = new DscPaymentIndicatorTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscPaymentIndicatorTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscPkgTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscPkgTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscPkgRow row : data.getDscPkgTable().getRowList()) {
            Map<DscPkgTableInternal.DscPkgTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscPkgTableInternal.DscPkgTableKey.class);
            tableKey.put(DscPkgTableInternal.DscPkgTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscPkgRowInternal((byte)row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscPkgTable = new DscPkgTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscPkgTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscPmfTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscPmfTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscPmfRow row : data.getDscPmfTable().getRowList()) {
            Map<DscPmfTableInternal.DscPmfTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscPmfTableInternal.DscPmfTableKey.class);
            tableKey.put(DscPmfTableInternal.DscPmfTableKey.VALUE, String.valueOf(row.getValue()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscPmfRowInternal(row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscPmfTable = new DscPmfTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscPmfTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscStatusIndicatorTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscStatusIndicatorTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscStatusIndicatorRow row : data.getDscStatusIndicatorTable().getRowList()) {
            Map<DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.class);
            tableKey.put(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.STATUS_INDICATOR, row.getStatusIndicator());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscStatusIndicatorRowInternal(row.getStatusIndicator(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscStatusIndicatorTable = new DscStatusIndicatorTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscStatusIndicatorTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDscValueCodeTable(DescriptionSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDscValueCodeTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DscValueCodeRow row : data.getDscValueCodeTable().getRowList()) {
            Map<DscValueCodeTableInternal.DscValueCodeTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DscValueCodeTableInternal.DscValueCodeTableKey.class);
            tableKey.put(DscValueCodeTableInternal.DscValueCodeTableKey.CODE, row.getValue());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DscValueCodeRowInternal(row.getValue(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDescription()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dscValueCodeTable = new DscValueCodeTableInternal(Collections.unmodifiableMap(finalTable));
        this.dscValueCodeTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    public final DscApcTableInternal getDscApcTable() {
        return this.dscApcTable;
    }

    public final DscDiscountFormulaTableInternal getDscDiscountFormulaTable() {
        return this.dscDiscountFormulaTable;
    }

    public final DscDx10TableInternal getDscDx10Table() {
        return this.dscDx10Table;
    }

    public final DscHcpcsTableInternal getDscHcpcsTable() {
        return this.dscHcpcsTable;
    }

    public final DscModifierTableInternal getDscModifierTable() {
        return this.dscModifierTable;
    }

    public final DscRevenueTableInternal getDscRevenueTable() {
        return this.dscRevenueTable;
    }

    public final DscClaimDispositionTableInternal getDscClaimDispositionTable() {
        return this.dscClaimDispositionTable;
    }

    public final DscClaimDispositionValueTableInternal getDscClaimDispositionValueTable() {
        return this.dscClaimDispositionValueTable;
    }

    public final DscCpfTableInternal getDscCpfTable() {
        return this.dscCpfTable;
    }

    public final DscEditDispositionTableInternal getDscEditDispositionTable() {
        return this.dscEditDispositionTable;
    }

    public final DscEditTableInternal getDscEditTable() {
        return this.dscEditTable;
    }

    public final DscErrorTableInternal getDscErrorTable() {
        return this.dscErrorTable;
    }

    public final DscLiafTableInternal getDscLiafTable() {
        return this.dscLiafTable;
    }

    public final DscLidrfTableInternal getDscLidrfTable() {
        return this.dscLidrfTable;
    }

    public final DscPafTableInternal getDscPafTable() {
        return this.dscPafTable;
    }

    public final DscPaymentIndicatorTableInternal getDscPaymentIndicatorTable() {
        return this.dscPaymentIndicatorTable;
    }

    public final DscPkgTableInternal getDscPkgTable() {
        return this.dscPkgTable;
    }

    public final DscPmfTableInternal getDscPmfTable() {
        return this.dscPmfTable;
    }

    public final DscStatusIndicatorTableInternal getDscStatusIndicatorTable() {
        return this.dscStatusIndicatorTable;
    }

    public final DscValueCodeTableInternal getDscValueCodeTable() {
        return this.dscValueCodeTable;
    }
}

