/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.DataModifierDao;
import gov.cms.oce.dao.data.row.DataModifierRowInternal;
import gov.cms.oce.dao.data.table.DataModifierTableInternal;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.HcpcsModifierList;
import gov.cms.oce.model.internal.HcpcsModifierTableData;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataModifierDaoImpl
implements DataModifierDao {
    private static final Logger logger = LoggerFactory.getLogger(DataModifierDaoImpl.class);

    @Override
    public final DataModifierRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Modifier parameter value is null/empty.");
            }
            return null;
        }
        Map<DataModifierTableInternal.DataModifierTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataModifierTableInternal.DataModifierTableKey.class);
        key.put(DataModifierTableInternal.DataModifierTableKey.MODIFIER, value);
        DataModifierTableInternal table = BinaryDataProvider.getInstance().getDataModifierTable();
        DataModifierRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("Modifier parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataModifierRowInternal getRow(HcpcsModifier hcpcsModifier, Short version) {
        return this.getRow(String.valueOf(hcpcsModifier.getValue()), version);
    }

    @Override
    public final void loadData(LineItemInternal line, Short version) {
        if (line.getFlags().isSet(LineFlags.INPUT_INVALID_MODIFIER)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No table data loaded as the CPT/HCPCS modifier is either blank or invalid.");
            }
        } else {
            HcpcsModifierList hcpcsModifierList = line.getHcpcsModifierInputList();
            for (HcpcsModifier hcpcsModifier : hcpcsModifierList.getValue()) {
                DataModifierRowInternal row = this.getRow(hcpcsModifier.getValue(), version);
                if (row == null) {
                    line.getFlags().set(LineFlags.INPUT_INVALID_MODIFIER);
                    hcpcsModifier.getFlags().set(ModifierFlags.INPUT_INVALID_MODIFIER);
                    continue;
                }
                FlagSet<ModifierFlags> flags = hcpcsModifier.getFlags();
                if (row.isNcci()) {
                    flags.set(ModifierFlags.DATA_MODIFIER_NCCI);
                }
                if (row.isTherapy()) {
                    flags.set(ModifierFlags.DATA_MODIFIER_THERAPY);
                }
                if (row.isNonDiscount()) {
                    flags.set(ModifierFlags.DATA_MODIFIER_NON_DISCOUNT);
                }
                if (row.isDiedTransferred()) {
                    flags.set(ModifierFlags.DATA_MODIFIER_DIED_TRANSFERRED);
                }
                if (row.isDeviceReqExclusion()) {
                    flags.set(ModifierFlags.DATA_MODIFIER_DEVICE_REQ_EXCLUSION);
                }
                HcpcsModifierTableData tableData = hcpcsModifier.getTableData();
                if (0 >= row.getDateActivated()) continue;
                tableData.setDateActivated(String.valueOf(row.getDateActivated()));
            }
        }
    }
}

