/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.VersionRangeDao;
import gov.cms.oce.dao.data.row.VersionRangeRowInternal;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.Version;
import gov.cms.oce.util.VersionRange;
import java.time.LocalDate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionRangeDaoImpl
implements VersionRangeDao {
    private static final Logger logger = LoggerFactory.getLogger(VersionRangeDaoImpl.class);

    private final Version getClaimDate(VersionRangeRowInternal row) {
        ClaimDate dateStarted = new ClaimDate();
        dateStarted.setValue(ClaimDate.getDateForInteger(row.getDateStarted()));
        ClaimDate dateEnded = new ClaimDate();
        dateEnded.setValue(ClaimDate.getDateForInteger(row.getDateEnded()));
        return new Version(row.getVersion(), dateStarted, dateEnded, row.getVersionId());
    }

    @Override
    public final VersionRange getVersionRange() {
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        return versionTable.getVersionRange();
    }

    @Override
    public final LocalDate getEarliestDate() {
        VersionRangeTableInternal table = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRangeRowInternal row = table.getFirstRowInternal();
        if (row == null) {
            logger.error("Could not determine earliest date supported. This should be considered a fatal error.");
            return null;
        }
        return row.getDateStartedAsDate();
    }

    @Override
    public final Version getEarliestVersion() {
        VersionRangeTableInternal table = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRangeRowInternal row = table.getFirstRowInternal();
        if (row != null) {
            return this.getClaimDate(row);
        }
        logger.error("Could not determine earliest version supported. This should be considered a fatal error.");
        return null;
    }

    @Override
    public final LocalDate getLatestDate() {
        VersionRangeTableInternal table = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRangeRowInternal row = table.getLastRowInternal();
        if (row == null) {
            logger.error("Could not determine latest date supported. This should be considered a fatal error.");
            return null;
        }
        return row.getDateEndedAsDate();
    }

    @Override
    public final Version getLatestVersion() {
        VersionRangeTableInternal table = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRangeRowInternal row = table.getLastRowInternal();
        if (row != null) {
            return this.getClaimDate(row);
        }
        logger.error("Could not determine latest version supported. This should be considered a fatal error.");
        return null;
    }

    @Override
    public final Version getVersion(ClaimDate targetDate) {
        if (targetDate == null) {
            return null;
        }
        Map<VersionRangeTableInternal.VersionRangeTableKey, String> key = TableKeyBuilder.createTableKeyMap(VersionRangeTableInternal.VersionRangeTableKey.class);
        key.put(VersionRangeTableInternal.VersionRangeTableKey.TARGET_DATE, targetDate.getValue());
        VersionRangeTableInternal table = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRangeRowInternal row = table.getRowInternal(key);
        if (row != null) {
            return this.getClaimDate(row);
        }
        logger.error("Could not determine version given claim's date started value of \"{}\".", (Object)targetDate.getValue());
        return null;
    }
}

