/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscCpfRowInternal;
import gov.cms.oce.dao.desc.table.DscCpfTableInternal;
import gov.cms.oce.dao.dsc.DscCpfDao;
import gov.cms.oce.model.internal.ClaimProcessedFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscCpfDaoImpl
implements DscCpfDao {
    private static final Logger logger = LoggerFactory.getLogger(DscCpfDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Claim processing flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscCpfTableInternal.DscCpfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscCpfTableInternal.DscCpfTableKey.class);
        key.put(DscCpfTableInternal.DscCpfTableKey.VALUE, value);
        DscCpfTableInternal table = BinaryDescriptionProvider.getInstance().getDscCpfTable();
        DscCpfRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for claim processing flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(ClaimProcessedFlag claimProcessedFlag, Short version) {
        String description = this.getDescription(String.valueOf(claimProcessedFlag.getValue()), version);
        claimProcessedFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Claim processing flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscCpfTableInternal.DscCpfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscCpfTableInternal.DscCpfTableKey.class);
        key.put(DscCpfTableInternal.DscCpfTableKey.VALUE, value);
        DscCpfTableInternal table = BinaryDescriptionProvider.getInstance().getDscCpfTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscCpfRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(ClaimProcessedFlag claimProcessedFlag) {
        String description = this.getLatestDescription(String.valueOf(claimProcessedFlag.getValue()));
        claimProcessedFlag.setDescription(description);
        return description;
    }
}

