/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscHcpcsRowInternal;
import gov.cms.oce.dao.desc.table.DscHcpcsTableInternal;
import gov.cms.oce.dao.dsc.DscHcpcsDao;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscHcpcsDaoImpl
implements DscHcpcsDao {
    private static final Logger logger = LoggerFactory.getLogger(DscHcpcsDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("CPT/HCPCS parameter is null/empty.");
            }
            return "";
        }
        Map<DscHcpcsTableInternal.DscHcpcsTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscHcpcsTableInternal.DscHcpcsTableKey.class);
        key.put(DscHcpcsTableInternal.DscHcpcsTableKey.HCPCS, value);
        DscHcpcsTableInternal table = BinaryDescriptionProvider.getInstance().getDscHcpcsTable();
        DscHcpcsRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for CPT/HCPCS \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(Hcpcs hcpcs, Short version) {
        String description = this.getDescription(hcpcs.getValue(), version);
        hcpcs.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("CPT/HCPCS parameter is null/empty.");
            }
            return "";
        }
        Map<DscHcpcsTableInternal.DscHcpcsTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscHcpcsTableInternal.DscHcpcsTableKey.class);
        key.put(DscHcpcsTableInternal.DscHcpcsTableKey.HCPCS, value);
        DscHcpcsTableInternal table = BinaryDescriptionProvider.getInstance().getDscHcpcsTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscHcpcsRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(Hcpcs hcpcs) {
        String description = this.getLatestDescription(hcpcs.getValue());
        hcpcs.setDescription(description);
        return description;
    }
}

