/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.MapBiosimilarRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapBiosimilarTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(MapBiosimilarTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<MapBiosimilarRowInternal>> table;

    private MapBiosimilarTableInternal() {
        this(null);
    }

    public MapBiosimilarTableInternal(Map<String, List<MapBiosimilarRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<MapBiosimilarRowInternal> getRowInternal(Map<MapBiosimilarTableKey, String> tableKey) {
        List<MapBiosimilarRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final MapBiosimilarRowInternal getRowInternal(Map<MapBiosimilarTableKey, String> tableKey, short version) {
        for (MapBiosimilarRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum MapBiosimilarTableKey {
        HCPCS,
        MODIFIER;

    }
}

