/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataApcRow;
import gov.cms.oce.ext.table.data.DataApcTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataApcTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataApcTableDefinition.class);
    private final String filePath;
    private final DataApcTable.Builder tableBuilder;
    private final DataApcRow.Builder rowBuilder;

    DataApcTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataApcTable.newBuilder();
        this.rowBuilder = DataApcRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataApcTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case APC: {
                this.rowBuilder.setApc(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            case STATUS_INDICATOR: {
                this.rowBuilder.setStatusIndicator(data);
                break;
            }
            case PAYMENT_INDICATOR: {
                this.rowBuilder.setPaymentIndicator(Integer.parseInt(data, 10));
                break;
            }
            case APC_PAYMENT: {
                this.rowBuilder.setApcPayment(Integer.parseInt(data, 10));
                break;
            }
            case MENTAL_HEALTH: {
                this.rowBuilder.setMentalHealth("1".equals(data));
                break;
            }
            case ER_VISIT: {
                this.rowBuilder.setErVisit("1".equals(data));
                break;
            }
            case DEVICE_OFFSET: {
                this.rowBuilder.setDeviceOffset(Integer.parseInt(data, 10));
                break;
            }
            case COMP_1_ID: {
                this.rowBuilder.setComp1Id(Integer.parseInt(data, 10));
                break;
            }
            case COMP_2_ID: {
                this.rowBuilder.setComp2Id(Integer.parseInt(data, 10));
                break;
            }
            case COMP_3_ID: {
                this.rowBuilder.setComp3Id(Integer.parseInt(data, 10));
                break;
            }
            case NUC_RAD_FB: {
                this.rowBuilder.setCapcSrs("1".equals(data));
                break;
            }
            case CAPC_SRS: {
                this.rowBuilder.setCapcSrs("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        APC,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION,
        STATUS_INDICATOR,
        PAYMENT_INDICATOR,
        APC_PAYMENT,
        MENTAL_HEALTH,
        ER_VISIT,
        DEVICE_OFFSET,
        COMP_1_ID,
        COMP_2_ID,
        COMP_3_ID,
        NUC_RAD_FB,
        CAPC_SRS;

    }
}

