/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataDiscountFormulaRow;
import gov.cms.oce.ext.table.data.DataDiscountFormulaTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDiscountFormulaTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataDiscountFormulaTableDefinition.class);
    private final String filePath;
    private final DataDiscountFormulaTable.Builder tableBuilder;
    private final DataDiscountFormulaRow.Builder rowBuilder;

    DataDiscountFormulaTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataDiscountFormulaTable.newBuilder();
        this.rowBuilder = DataDiscountFormulaRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataDiscountFormulaTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case DISCOUNT_KEY: {
                this.rowBuilder.setDiscountKey(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DISCOUNT_FORMULA: {
                this.rowBuilder.setDiscountFormula(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        DISCOUNT_KEY,
        LO_VERSION,
        HI_VERSION,
        DISCOUNT_FORMULA,
        DESCRIPTION;

    }
}

