/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataDx10Row;
import gov.cms.oce.ext.table.data.DataDx10Table;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDx10TableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataDx10TableDefinition.class);
    private final String filePath;
    private final DataDx10Table.Builder tableBuilder;
    private final DataDx10Row.Builder rowBuilder;

    DataDx10TableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataDx10Table.newBuilder();
        this.rowBuilder = DataDx10Row.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataDx10Table(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case DIAGNOSIS: {
                this.rowBuilder.setDiagnosis(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            case LO_AGE: {
                this.rowBuilder.setLoAge(Integer.parseInt(data, 10));
                break;
            }
            case HI_AGE: {
                this.rowBuilder.setHiAge(Integer.parseInt(data, 10));
                break;
            }
            case SEX: {
                this.rowBuilder.setSex(Integer.parseInt(data, 10));
                break;
            }
            case EXTERNAL_CAUSE: {
                this.rowBuilder.setExternalCause("1".equals(data));
                break;
            }
            case MENTAL_HEALTH: {
                this.rowBuilder.setMentalHealth("1".equals(data));
                break;
            }
            case MANIFESTATION: {
                this.rowBuilder.setManifestation("1".equals(data));
                break;
            }
            case CODE_FIRST: {
                this.rowBuilder.setCodeFirst("1".equals(data));
                break;
            }
            case UNACCEPTABLE_PDX: {
                this.rowBuilder.setUnacceptablePdx("1".equals(data));
                break;
            }
            case UNACCEPTABLE_PDX_EXCLUSION: {
                this.rowBuilder.setUnacceptablePdxExclusion("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        DIAGNOSIS,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION,
        LO_AGE,
        HI_AGE,
        SEX,
        EXTERNAL_CAUSE,
        MENTAL_HEALTH,
        MANIFESTATION,
        CODE_FIRST,
        UNACCEPTABLE_PDX,
        UNACCEPTABLE_PDX_EXCLUSION;

    }
}

