/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataModifierRow;
import gov.cms.oce.ext.table.data.DataModifierTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataModifierTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataModifierTableDefinition.class);
    private final String filePath;
    private final DataModifierTable.Builder tableBuilder;
    private final DataModifierRow.Builder rowBuilder;

    DataModifierTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataModifierTable.newBuilder();
        this.rowBuilder = DataModifierRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataModifierTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case MODIFIER: {
                this.rowBuilder.setModifier(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            case DATE_ACTIVATED: {
                this.rowBuilder.setDateActivated(Integer.parseInt(data, 10));
                break;
            }
            case NCCI: {
                this.rowBuilder.setNcci("1".equals(data));
                break;
            }
            case THERAPY: {
                this.rowBuilder.setTherapy("1".equals(data));
                break;
            }
            case NON_DISCOUNT: {
                this.rowBuilder.setNonDiscount("1".equals(data));
                break;
            }
            case DIED_TRANSFERRED: {
                this.rowBuilder.setDiedTransferred("1".equals(data));
                break;
            }
            case DEVICE_REQ_EXCLUSION: {
                this.rowBuilder.setDeviceReqExclusion("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        MODIFIER,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION,
        DATE_ACTIVATED,
        NCCI,
        THERAPY,
        NON_DISCOUNT,
        DIED_TRANSFERRED,
        DEVICE_REQ_EXCLUSION;

    }
}

