/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataRevenueRow;
import gov.cms.oce.ext.table.data.DataRevenueTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataRevenueTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataRevenueTableDefinition.class);
    private final String filePath;
    private final DataRevenueTable.Builder tableBuilder;
    private final DataRevenueRow.Builder rowBuilder;

    DataRevenueTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataRevenueTable.newBuilder();
        this.rowBuilder = DataRevenueRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataRevenueTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case REVENUE_CODE: {
                this.rowBuilder.setRevenueCode(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            case STATUS_INDICATOR: {
                this.rowBuilder.setStatusIndicator(data);
                break;
            }
            case NOT_RECOGNIZED: {
                this.rowBuilder.setNotRecognized("1".equals(data));
                break;
            }
            case THERAPY: {
                this.rowBuilder.setTherapy("1".equals(data));
                break;
            }
            case BYPASS_E48: {
                this.rowBuilder.setBypassE48("1".equals(data));
                break;
            }
            case STATUTORY_EXCLUSION: {
                this.rowBuilder.setStatutoryExclusion("1".equals(data));
                break;
            }
            case BUNDLED_IN_BIOLOGICAL: {
                this.rowBuilder.setBundledInBiological("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        REVENUE_CODE,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION,
        STATUS_INDICATOR,
        NOT_RECOGNIZED,
        THERAPY,
        BYPASS_E48,
        STATUTORY_EXCLUSION,
        BUNDLED_IN_BIOLOGICAL;

    }
}

