/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscEditDispositionRow;
import gov.cms.oce.ext.table.desc.DscEditDispositionTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscEditDispositionTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscEditDispositionTableDefinition.class);
    private final String filePath;
    private final DscEditDispositionTable.Builder tableBuilder;
    private final DscEditDispositionRow.Builder rowBuilder;

    DscEditDispositionTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscEditDispositionTable.newBuilder();
        this.rowBuilder = DscEditDispositionRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscEditDispositionTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case ID: {
                this.rowBuilder.setId(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case ABBREVIATION: {
                this.rowBuilder.setAbbreviation(data);
                break;
            }
            case NAME: {
                this.rowBuilder.setName(data);
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        ID,
        LO_VERSION,
        HI_VERSION,
        ABBREVIATION,
        NAME,
        DESCRIPTION;

    }
}

