/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscLidrfRow;
import gov.cms.oce.ext.table.desc.DscLidrfTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscLidrfTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscLidrfTableDefinition.class);
    private final String filePath;
    private final DscLidrfTable.Builder tableBuilder;
    private final DscLidrfRow.Builder rowBuilder;

    DscLidrfTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscLidrfTable.newBuilder();
        this.rowBuilder = DscLidrfRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscLidrfTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case VALUE: {
                this.rowBuilder.setValue(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        VALUE,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION;

    }
}

