/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscPaymentIndicatorRow;
import gov.cms.oce.ext.table.desc.DscPaymentIndicatorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscPaymentIndicatorTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscPaymentIndicatorTableDefinition.class);
    private final String filePath;
    private final DscPaymentIndicatorTable.Builder tableBuilder;
    private final DscPaymentIndicatorRow.Builder rowBuilder;

    DscPaymentIndicatorTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscPaymentIndicatorTable.newBuilder();
        this.rowBuilder = DscPaymentIndicatorRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscPaymentIndicatorTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case PAYMENT_INDICATOR: {
                this.rowBuilder.setPaymentIndicator(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        PAYMENT_INDICATOR,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION;

    }
}

