/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapAddonType3Row;
import gov.cms.oce.ext.table.data.MapAddonType3Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapAddonType3TableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapAddonType3TableDefinition.class);
    private final String filePath;
    private final MapAddonType3Table.Builder tableBuilder;
    private final MapAddonType3Row.Builder rowBuilder;

    MapAddonType3TableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapAddonType3Table.newBuilder();
        this.rowBuilder = MapAddonType3Row.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapAddonType3Table(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case ADDON: {
                this.rowBuilder.setAddon(data);
                break;
            }
            case ADDON_PRIMARY: {
                this.rowBuilder.setAddonPrimary(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        ADDON,
        ADDON_PRIMARY,
        LO_VERSION,
        HI_VERSION;

    }
}

