/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapCompositeRow;
import gov.cms.oce.ext.table.data.MapCompositeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapCompositeTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapCompositeTableDefinition.class);
    private final String filePath;
    private final MapCompositeTable.Builder tableBuilder;
    private final MapCompositeRow.Builder rowBuilder;

    MapCompositeTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapCompositeTable.newBuilder();
        this.rowBuilder = MapCompositeRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapCompositeTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case HCPCS: {
                this.rowBuilder.setHcpcs(data);
                break;
            }
            case COMPOSITE_APC: {
                this.rowBuilder.setCompositeApc(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case LIST_TYPE: {
                this.rowBuilder.setListType(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        HCPCS,
        COMPOSITE_APC,
        LO_VERSION,
        HI_VERSION,
        LIST_TYPE;

    }
}

