/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapModifierConflictRow;
import gov.cms.oce.ext.table.data.MapModifierConflictTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapModifierConflictTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapModifierConflictTableDefinition.class);
    private final String filePath;
    private final MapModifierConflictTable.Builder tableBuilder;
    private final MapModifierConflictRow.Builder rowBuilder;

    MapModifierConflictTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapModifierConflictTable.newBuilder();
        this.rowBuilder = MapModifierConflictRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapModifierConflictTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case MODIFIER1: {
                this.rowBuilder.setModifier1(data);
                break;
            }
            case MODIFIER2: {
                this.rowBuilder.setModifier2(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        MODIFIER1,
        MODIFIER2,
        LO_VERSION,
        HI_VERSION;

    }
}

