/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.OffsetApcRow;
import gov.cms.oce.ext.table.data.OffsetApcTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetApcTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(OffsetApcTableDefinition.class);
    private final String filePath;
    private final OffsetApcTable.Builder tableBuilder;
    private final OffsetApcRow.Builder rowBuilder;

    OffsetApcTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = OffsetApcTable.newBuilder();
        this.rowBuilder = OffsetApcRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setOffsetApcTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case GROUP_ID: {
                this.rowBuilder.setGroupId(Integer.parseInt(data, 10));
                break;
            }
            case LIST_ID: {
                this.rowBuilder.setListId(Integer.parseInt(data, 10));
                break;
            }
            case APC: {
                this.rowBuilder.setApc(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case AMOUNT: {
                this.rowBuilder.setAmount(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        GROUP_ID,
        LIST_ID,
        APC,
        LO_VERSION,
        HI_VERSION,
        AMOUNT;

    }
}

