/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.OffsetHcpcsRow;
import gov.cms.oce.ext.table.data.OffsetHcpcsTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetHcpcsTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(OffsetHcpcsTableDefinition.class);
    private final String filePath;
    private final OffsetHcpcsTable.Builder tableBuilder;
    private final OffsetHcpcsRow.Builder rowBuilder;

    OffsetHcpcsTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = OffsetHcpcsTable.newBuilder();
        this.rowBuilder = OffsetHcpcsRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setOffsetHcpcsTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case LIST_ID: {
                this.rowBuilder.setListId(Integer.parseInt(data, 10));
                break;
            }
            case HCPCS: {
                this.rowBuilder.setHcpcs(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case AMOUNT: {
                this.rowBuilder.setAmount(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        LIST_ID,
        HCPCS,
        LO_VERSION,
        HI_VERSION,
        AMOUNT;

    }
}

