/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.VersionRangeRow;
import gov.cms.oce.ext.table.data.VersionRangeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionRangeTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(VersionRangeTableDefinition.class);
    private final String filePath;
    private final VersionRangeTable.Builder tableBuilder;
    private final VersionRangeRow.Builder rowBuilder;

    VersionRangeTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = VersionRangeTable.newBuilder();
        this.rowBuilder = VersionRangeRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setVersionRangeTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case VERSION: {
                this.rowBuilder.setVersion(Integer.parseInt(data, 10));
                break;
            }
            case DATE_STARTED: {
                this.rowBuilder.setDateStarted(Integer.parseInt(data, 10));
                break;
            }
            case DATE_ENDED: {
                this.rowBuilder.setDateEnded(Integer.parseInt(data, 10));
                break;
            }
            case VERSION_ID: {
                this.rowBuilder.setVersionId(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        VERSION,
        DATE_STARTED,
        DATE_ENDED,
        VERSION_ID;

    }
}

