/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import gov.cms.oce.ext.table.util.Combination;
import gov.cms.oce.ext.table.util.CombinationUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CombinationOptimizer<D> {
    private static final Logger logger = LoggerFactory.getLogger(CombinationOptimizer.class);

    public List<Combination<D>> optimize(Map<D, LinkedList<D>> rightForLeft) {
        Set<Combination<D>> codeCombinations = CombinationUtil.combine(rightForLeft);
        return this.optimize(codeCombinations);
    }

    public List<Combination<D>> optimize(Collection<Combination<D>> codeCombinations) {
        OptimizerProgress progress = this.withProgress(codeCombinations.size());
        if (progress != null) {
            progress.logSummary("Starting with", codeCombinations);
            progress.startLogging();
        }
        List<Combination<D>> optimized = this.optimize(codeCombinations, progress);
        if (progress != null) {
            progress.logProgress();
            progress.endLogging();
            progress.logSummary("Resulting in", optimized);
            progress.logImprovement(codeCombinations, optimized);
        }
        return optimized;
    }

    protected OptimizerProgress withProgress(int startSize) {
        return new OptimizerProgress(startSize);
    }

    protected abstract List<Combination<D>> optimize(Collection<Combination<D>> var1, OptimizerProgress var2);

    static class LinkedHashMultimap<K, V>
    extends LinkedHashMap<K, LinkedList<V>> {
        private static final long serialVersionUID = 1752737991085559689L;

        public LinkedHashMultimap() {
        }

        public LinkedHashMultimap(int initialCapacity) {
            super(initialCapacity);
        }

        public LinkedHashMultimap(Map<? extends K, ? extends LinkedList<V>> m) {
            super(m);
        }

        public LinkedHashMultimap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public Stream<V> streamAllValues() {
            return this.values().stream().flatMap(element -> element.stream());
        }

        public boolean putSingle(K key, V value) {
            return this.computeIfAbsent(key, k -> new LinkedList()).add(value);
        }

        @Override
        public LinkedList<V> put(K key, LinkedList<V> value) {
            LinkedList previous = this.containsKey(key) ? new LinkedList((Collection)this.get(key)) : null;
            value.stream().forEach((? super T val) -> this.putSingle(key, val));
            return previous;
        }

        @Override
        public void putAll(Map<? extends K, ? extends LinkedList<V>> m) {
            m.entrySet().stream().forEach((? super T entry) -> this.put(entry.getKey(), (LinkedList)entry.getValue()));
        }
    }

    static class OptimizerProgress {
        private int totalCombos;
        private int processedCombos = 0;
        private long totalUnoptimized = 0L;
        private long totalOptimized = 0L;
        private Timer timer = null;
        private Object sync = new Object();

        public OptimizerProgress(int total) {
            this.totalCombos = total;
        }

        public void startLogging() {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    this.logProgress();
                }
            }, 1000L, 5000L);
        }

        public void endLogging() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase(Combination<?> lookup, Collection<? extends Combination<?>> matches, Collection<? extends Combination<?>> optimized) {
            Object object = this.sync;
            synchronized (object) {
                this.increaseTotalProcessedUnoptimized(lookup);
                this.increaseTotalProcessedUnoptimized(matches);
                this.increaseTotalProcessedOptimized(optimized);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase(Combination<?> lookup, Combination<?> match, Collection<? extends Combination<?>> optimized) {
            Object object = this.sync;
            synchronized (object) {
                this.increaseTotalProcessedUnoptimized(lookup);
                this.increaseTotalProcessedUnoptimized(match);
                this.increaseTotalProcessedOptimized(optimized);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase(Combination<?> lookup, Collection<? extends Combination<?>> matches, Combination<?> optimized) {
            Object object = this.sync;
            synchronized (object) {
                this.increaseTotalProcessedUnoptimized(lookup);
                this.increaseTotalProcessedUnoptimized(matches);
                this.increaseTotalProcessedOptimized(optimized);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase(Combination<?> lookup) {
            Object object = this.sync;
            synchronized (object) {
                this.increaseTotalProcessedUnoptimized(lookup);
            }
        }

        public void setRemainingCombos(int remaining) {
            this.processedCombos = this.totalCombos - remaining;
        }

        private void increaseTotalProcessedUnoptimized(Collection<? extends Combination<?>> combos) {
            if (combos != null) {
                this.totalUnoptimized += combos.stream().flatMap(combo -> combo.getRight().stream()).count();
            }
        }

        private void increaseTotalProcessedUnoptimized(Combination<?> combo) {
            if (combo != null) {
                this.totalUnoptimized += combo.getRight().stream().count();
            }
        }

        private void increaseTotalProcessedOptimized(Collection<? extends Combination<?>> combos) {
            if (combos != null) {
                this.totalOptimized += combos.stream().flatMap(combo -> combo.getRight().stream()).count();
            }
        }

        private void increaseTotalProcessedOptimized(Combination<?> combo) {
            if (combo != null) {
                this.totalOptimized += combo.getRight().stream().count();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logProgress() {
            Object object = this.sync;
            synchronized (object) {
                int percentage = (int)((double)this.processedCombos / (double)this.totalCombos * 100.0);
                long optimizerImprovement = this.totalUnoptimized - this.totalOptimized;
                logger.info("Optimized {} of {} combination groups ({}%). Total accumulated reduction: {} right-side entries", this.processedCombos, this.totalCombos, percentage, optimizerImprovement);
            }
        }

        public <D> void logSummary(String prefix, Collection<? extends Combination<D>> codeCombinations) {
            logger.info("{}: {} combinations", (Object)prefix, (Object)codeCombinations.size());
            logger.info("  Containing {} left-side elements", (Object)CombinationUtil.count(codeCombinations, Combination::getLeft));
            logger.info("  Containing {} right-side elements", (Object)CombinationUtil.count(codeCombinations, Combination::getRight));
        }

        public <D> void logImprovement(Collection<? extends Combination<D>> codeCombinations, Collection<? extends Combination<D>> optimized) {
            long diffLeft = CombinationUtil.count(optimized, Combination::getLeft) - CombinationUtil.count(codeCombinations, Combination::getLeft);
            long diffRight = CombinationUtil.count(codeCombinations, Combination::getRight) - CombinationUtil.count(optimized, Combination::getRight);
            logger.info("Total improvement:");
            logger.info("  {} more left-side elements", (Object)diffLeft);
            logger.info("  {} less right-side elements", (Object)diffRight);
        }
    }
}

