/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import gov.cms.oce.ext.table.util.Combination;
import gov.cms.oce.ext.table.util.CombinationOptimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CombinationOptimizerEquals
extends CombinationOptimizer<String> {
    @Override
    protected List<Combination<String>> optimize(Collection<Combination<String>> codeCombinations, CombinationOptimizer.OptimizerProgress progress) {
        LinkedList<Combination<String>> results = new LinkedList<Combination<String>>();
        CombinationOptimizer.LinkedHashMultimap combos = codeCombinations.stream().collect(Collectors.groupingBy(combo -> combo.getRight().size(), CombinationOptimizer.LinkedHashMultimap::new, Collectors.toCollection(LinkedList::new)));
        Iterator combosValuesIterator = combos.values().iterator();
        while (combosValuesIterator.hasNext()) {
            LinkedList lookups = (LinkedList)combosValuesIterator.next();
            while (!lookups.isEmpty()) {
                Combination lookup = (Combination)lookups.removeFirst();
                int lookupRightSideSize = lookup.getRight().size();
                LinkedList potentialCombos = (LinkedList)combos.get(lookupRightSideSize);
                if (potentialCombos != null) {
                    List<Combination<String>> matches = CombinationOptimizerEquals.equalsSearchAndRemove(lookup, potentialCombos);
                    if (matches.isEmpty()) {
                        results.add(lookup);
                        progress.increase(lookup, matches, lookup);
                    } else {
                        List<Combination<String>> resultingCombos = this.optimizeMatches(lookup, matches);
                        results.addAll(resultingCombos);
                        progress.increase(lookup, matches, resultingCombos);
                    }
                } else {
                    progress.increase(lookup);
                }
                progress.setRemainingCombos(lookups.size());
            }
            combosValuesIterator.remove();
        }
        return results;
    }

    private List<Combination<String>> optimizeMatches(Combination<String> lookup, List<Combination<String>> matches) {
        Combination<String> updatedCombination = lookup.toBuilder().addAllLeft(matches.stream().flatMap(combo -> combo.getLeft().stream()).collect(Collectors.toSet())).build();
        return Arrays.asList(updatedCombination);
    }

    private static <D> List<Combination<D>> equalsSearchAndRemove(Combination<D> lookup, LinkedList<Combination<D>> allOthers) {
        Set<D> lookupRight = lookup.getRight();
        ArrayList<Combination<D>> matches = new ArrayList<Combination<D>>();
        Iterator copareToIterator = allOthers.iterator();
        while (copareToIterator.hasNext()) {
            Combination potentialMatch = (Combination)copareToIterator.next();
            if (!lookupRight.equals(potentialMatch.getRight())) continue;
            matches.add(potentialMatch);
            copareToIterator.remove();
        }
        return matches;
    }
}

