/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import gov.cms.oce.ext.table.util.Combination;
import gov.cms.oce.ext.table.util.CombinationOptimizer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CombinationOptimizerIntersect
extends CombinationOptimizer<String> {
    private final boolean resultsLookup;

    public CombinationOptimizerIntersect(boolean resultsLookup) {
        this.resultsLookup = resultsLookup;
    }

    @Override
    protected List<Combination<String>> optimize(Collection<Combination<String>> codeCombinations, CombinationOptimizer.OptimizerProgress progress) {
        LinkedList results = new LinkedList();
        LinkedList combos = new LinkedList(codeCombinations);
        while (!combos.isEmpty()) {
            Combination<String> lookup = combos.removeFirst();
            MatchingCombo<String> match = this.resultsLookup ? CombinationOptimizerIntersect.intersectionSearchAndRemove(lookup, combos, results) : CombinationOptimizerIntersect.intersectionSearchAndRemove(lookup, combos);
            if (match == null) {
                results.add(lookup);
                progress.increase(lookup, null, lookup);
            } else {
                List<Combination<String>> resultingCombos = this.optimizeMatch(lookup, match);
                results.addAll(resultingCombos);
                progress.increase(lookup, match.combo, resultingCombos);
            }
            progress.setRemainingCombos(combos.size());
        }
        return results;
    }

    private List<Combination<String>> optimizeMatch(Combination<String> lookup, MatchingCombo<String> match) {
        Combination remainingCompareCombo;
        LinkedList<Combination<String>> resultingCombinations = new LinkedList<Combination<String>>();
        Combination<String> intersectCombo = Combination.builder(String.class).withRight(match.intersection).addAllLeft(lookup.getLeft()).addAllLeft(match.combo.getLeft()).build();
        resultingCombinations.add(intersectCombo);
        Combination<String> remainingLookupCombo = CombinationOptimizerIntersect.rightCodesWithoutIntersect(lookup, match.intersection);
        if (!remainingLookupCombo.getRight().isEmpty()) {
            resultingCombinations.add(remainingLookupCombo);
        }
        if (!(remainingCompareCombo = CombinationOptimizerIntersect.rightCodesWithoutIntersect(match.combo, match.intersection)).getRight().isEmpty()) {
            resultingCombinations.add(remainingCompareCombo);
        }
        return resultingCombinations;
    }

    private static <D> Combination<D> rightCodesWithoutIntersect(Combination<D> combo, Collection<D> intersectCodes) {
        LinkedHashSet<D> rightTransferredWithoutIntersect = new LinkedHashSet<D>(combo.getRight());
        rightTransferredWithoutIntersect.removeAll(intersectCodes);
        return combo.toBuilder().withRight(rightTransferredWithoutIntersect).build();
    }

    private static <D> MatchingCombo<D> intersectionSearchAndRemove(Combination<D> lookup, List<Combination<D>> allOthers, List<Combination<D>> results) {
        MatchingCombo<D> match1 = CombinationOptimizerIntersect.intersectionSearchAndRemove(lookup, allOthers);
        MatchingCombo<D> match2 = CombinationOptimizerIntersect.intersectionSearchAndRemove(lookup, results);
        MatchingCombo<D> match = null;
        if (match1 != null && match2 != null) {
            if (match1.intersection.size() > match2.intersection.size()) {
                match = match1;
                results.add(match2.combo);
            } else {
                match = match2;
                allOthers.add(match1.combo);
            }
        } else if (match2 != null) {
            match = match2;
        } else if (match1 != null) {
            match = match1;
        }
        return match;
    }

    private static <D> MatchingCombo<D> intersectionSearchAndRemove(Combination<D> lookup, List<Combination<D>> allOthers) {
        Set<D> lookupLeft = lookup.getLeft();
        Set<D> lookupRight = lookup.getRight();
        MatchingCombo<D> match = null;
        int matchIndex = -1;
        for (int compareIndex = 0; compareIndex < allOthers.size(); ++compareIndex) {
            Combination<D> compare = allOthers.get(compareIndex);
            Set<D> compareLeft = compare.getLeft();
            Set<D> compareRight = compare.getRight();
            Set intersection = lookupRight.stream().filter(compareRight::contains).collect(Collectors.toCollection(LinkedHashSet::new));
            boolean isOptimizationCandidate = CombinationOptimizerIntersect.isOptimizationWorthIt(lookupLeft, lookupRight, compareLeft, compareRight, intersection);
            if (!isOptimizationCandidate || match != null && intersection.size() <= match.intersection.size()) continue;
            match = new MatchingCombo<D>(compare, intersection);
            matchIndex = compareIndex;
        }
        if (matchIndex > -1) {
            allOthers.remove(matchIndex);
        }
        return match;
    }

    private static <D> boolean isOptimizationWorthIt(Set<D> lookupLeft, Set<D> lookupRight, Set<D> compareLeft, Set<D> compareRight, Set<D> intersection) {
        int totalEntriesBeforeOptimization = lookupLeft.size() + compareLeft.size() + lookupRight.size() + compareRight.size();
        int commonCodesCount = intersection.size();
        if (commonCodesCount == 0) {
            return false;
        }
        int totalEntriesAfterOptimization = totalEntriesBeforeOptimization - commonCodesCount;
        if (lookupRight.size() - commonCodesCount > 0) {
            totalEntriesAfterOptimization += lookupLeft.size();
        }
        if (compareRight.size() - commonCodesCount > 0) {
            totalEntriesAfterOptimization += compareLeft.size();
        }
        return totalEntriesBeforeOptimization > totalEntriesAfterOptimization;
    }

    public static class MatchingCombo<D> {
        public final Combination<D> combo;
        public final Set<D> intersection;

        public MatchingCombo(Combination<D> combo, Set<D> intersection) {
            this.combo = combo;
            this.intersection = intersection;
        }

        public String toString() {
            return this.combo.toString();
        }
    }
}

