/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import gov.cms.oce.ext.table.util.Combination;
import gov.cms.oce.ext.table.util.CombinationOptimizer;
import gov.cms.oce.ext.table.util.CombinationOptimizerEquals;
import gov.cms.oce.ext.table.util.CombinationOptimizerIntersect;
import gov.cms.oce.ext.table.util.CombinationUtil;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationOptimizerRepeated
extends CombinationOptimizer<String> {
    private static final Logger logger = LoggerFactory.getLogger(CombinationOptimizerRepeated.class);
    private final CombinationOptimizerEquals equalsOptimizer;
    private final CombinationOptimizerIntersect intersectOptimizer;
    private final Integer maxIterations;

    public CombinationOptimizerRepeated(Integer maxIterations, boolean intersectionResultsLookup) {
        this.maxIterations = maxIterations;
        this.equalsOptimizer = new CombinationOptimizerEquals();
        this.intersectOptimizer = new CombinationOptimizerIntersect(intersectionResultsLookup);
    }

    @Override
    protected CombinationOptimizer.OptimizerProgress withProgress(int startSize) {
        return null;
    }

    @Override
    public List<Combination<String>> optimize(Collection<Combination<String>> codeCombinations, CombinationOptimizer.OptimizerProgress progress) {
        logger.info("Initial step: Equals optimization");
        List<Combination<String>> optimized = this.equalsOptimizer.optimize(codeCombinations);
        long previousLeftSideCount = CombinationUtil.count(optimized, Combination::getLeft);
        long previousRightSideCount = CombinationUtil.count(optimized, Combination::getRight);
        long leftSideDiff = previousLeftSideCount;
        long rightSideDiff = previousRightSideCount;
        int iteration = 1;
        do {
            logger.info("Iteration #{}:", (Object)iteration);
            logger.info("Intersection optimization", (Object)iteration);
            optimized = this.intersectOptimizer.optimize(optimized);
            logger.info("Equals optimization", (Object)iteration);
            optimized = this.equalsOptimizer.optimize(optimized);
            long currentLeftSideCount = CombinationUtil.count(optimized, Combination::getLeft);
            long currentRightSideCount = CombinationUtil.count(optimized, Combination::getRight);
            leftSideDiff = currentLeftSideCount - previousLeftSideCount;
            rightSideDiff = previousRightSideCount - currentRightSideCount;
            previousLeftSideCount = currentLeftSideCount;
            previousRightSideCount = currentRightSideCount;
            logger.info("Iteration #{} resulted in a increase of {} left and a reduction of {} right-side elements", iteration, leftSideDiff, rightSideDiff);
        } while (rightSideDiff > 0L && leftSideDiff > 0L && (this.maxIterations == null || ++iteration < this.maxIterations));
        return optimized;
    }
}

