/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.DiscountFormula;
import gov.cms.oce.model.internal.EditBypass;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PackagingFlag;
import gov.cms.oce.model.internal.PaymentAdjustmentFlag;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.RejectionDenialFlag;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContractorOverride
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ContractorOverride.class);

    ContractorOverride() {
    }

    private final void setPaymentApc(LineItemInternal line, Apc bypass) {
        Apc paymentApc = line.getPaymentApc();
        paymentApc.setValue(bypass.getValue());
        paymentApc.setDescription(bypass.getDescription());
    }

    private final void setStatusIndicator(LineItemInternal line, StatusIndicator bypass) {
        StatusIndicator statusIndicator = line.getStatusIndicator();
        statusIndicator.setValue(bypass.getValue());
        statusIndicator.setDescription(bypass.getDescription());
    }

    private final void setPaymentIndicator(LineItemInternal line, PaymentIndicator bypass) {
        PaymentIndicator paymentIndicator = line.getPaymentIndicator();
        paymentIndicator.setValue(bypass.getValue());
        paymentIndicator.setDescription(bypass.getDescription());
    }

    private final void setDiscountingFormula(LineItemInternal line, DiscountFormula bypass) {
        DiscountFormula lineValue = line.getDiscountingFormula();
        lineValue.setValue(bypass.getValue());
        lineValue.setDescription(bypass.getDescription());
    }

    private final void setRejectionDenialFlag(LineItemInternal line, RejectionDenialFlag bypass) {
        RejectionDenialFlag lineValue = line.getRejectionDenialFlag();
        lineValue.setValue(bypass.getValue());
        lineValue.setDescription(bypass.getDescription());
    }

    private final void setPackagingFlag(LineItemInternal line, PackagingFlag bypass) {
        PackagingFlag lineValue = line.getPackagingFlag();
        lineValue.setValue(bypass.getValue());
        lineValue.setDescription(bypass.getDescription());
    }

    private final void setPaymentAdjustmentFlag01(LineItemInternal line, PaymentAdjustmentFlag bypass) {
        PaymentAdjustmentFlag lineValue = line.getPaymentAdjustmentFlag01();
        lineValue.setValue(bypass.getValue());
        lineValue.setDescription(bypass.getDescription());
    }

    private final void setPaymentAdjustmentFlag02(LineItemInternal line, PaymentAdjustmentFlag bypass) {
        PaymentAdjustmentFlag lineValue = line.getPaymentAdjustmentFlag02();
        lineValue.setValue(bypass.getValue());
        lineValue.setDescription(bypass.getDescription());
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        block10: for (LineItemInternal line : claim.getLineItemList().getValue()) {
            EditBypass bypass = line.getEditBypass();
            if (claim.isOpps() && line.matchesActionFlag(0) && line.isContractorEditBypassedSet()) {
                this.setPaymentApc(line, bypass.getApc());
                this.setStatusIndicator(line, bypass.getStatusIndicator());
                this.setPaymentIndicator(line, bypass.getPaymentIndicator());
                this.setDiscountingFormula(line, bypass.getDiscountingFormula());
                this.setRejectionDenialFlag(line, bypass.getRejectionDenialFlag());
                this.setPackagingFlag(line, bypass.getPackagingFlag());
                this.setPaymentAdjustmentFlag01(line, bypass.getPaymentAdjustmentFlag01());
                this.setPaymentAdjustmentFlag02(line, bypass.getPaymentAdjustmentFlag02());
            }
            if (!claim.isContractorEditBypassedSet() && !line.isContractorEditBypassedSet()) continue;
            if (bypass.getPaymentMethodFlag().getValue() == null) {
                line.setPaymentMethodFlag("Z");
                continue;
            }
            switch (bypass.getPaymentMethodFlag().getValue()) {
                case "V": 
                case "W": 
                case "X": 
                case "Y": 
                case "Z": {
                    line.setPaymentMethodFlag(bypass.getPaymentMethodFlag().getValue());
                    continue block10;
                }
            }
            line.setPaymentMethodFlag("Z");
        }
        return false;
    }
}

