/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.dao.data.DataRevenueDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadRevenueCodeTableData
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(LoadRevenueCodeTableData.class);

    LoadRevenueCodeTableData() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        DataRevenueDao dao = processor.getResourceManager().getDataDaoFactory().getDataRevenueDao();
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getReceiptDateVersionAsPrimitive();
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (!line.getFlags().isNotSet(LineFlags.INPUT_EMPTY_REVENUE_CODE)) continue;
            dao.loadData(line, version);
        }
        return false;
    }
}

