/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateClaimDate
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateClaimDate.class);

    ValidateClaimDate() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_DATE_STARTED)) {
            claim.assignEdit(EditValue.INVALID_DATE_1);
            claim.setReturnCode(ReturnCode.BAD_FROM_DATE, ClaimProcessedValue.ONE);
            return true;
        }
        if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_DATE_ENDED)) {
            claim.assignEdit(EditValue.INVALID_DATE_1);
            claim.setReturnCode(ReturnCode.BAD_THRU_DATE, ClaimProcessedValue.ONE);
            return true;
        }
        if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_RECEIPT_DATE)) {
            claim.assignEdit(EditValue.INVALID_RECEIPT_DATE);
            claim.setReturnCode(ReturnCode.INVALID_RECEIPT_DATE, ClaimProcessedValue.ONE);
            return true;
        }
        if (claim.getDateEnded().getValueAsDate().isBefore(claim.getDateStarted().getValueAsDate())) {
            claim.getFlags().set(ClaimFlags.INPUT_DATE_STARTED_AFTER_DATE_ENDED);
            claim.assignEdit(EditValue.INVALID_DATE_1);
            claim.setReturnCode(ReturnCode.BAD_DATE_SEQUENCE, ClaimProcessedValue.ONE);
            return true;
        }
        return false;
    }
}

