/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveDutyServiceMemberInpatientLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ActiveDutyServiceMemberInpatientLogic.class);

    ActiveDutyServiceMemberInpatientLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            boolean adsmPresent = false;
            boolean inpatientPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (line.matchesActionFlag(8)) {
                    adsmPresent = true;
                    if (inpatientPresent) break;
                }
                if (!line.matchesStatusIndicator("C")) continue;
                inpatientPresent = true;
                if (!adsmPresent) continue;
                break;
            }
            if (!adsmPresent || !inpatientPresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.matchesStatusIndicator("C")) continue;
            }
        }
        return false;
    }
}

