/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;

public final class AllogeneicTransplantLogic
implements Logic {
    AllogeneicTransplantLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean found = false;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_INVALID_REVENUE_CODE, LineFlags.INPUT_EMPTY_REVENUE_CODE, LineFlags.DATA_HCPCS_ALLOGENEIC_TRANSPLANT, LineFlags.DATA_REVENUE_NOT_RECOGNIZED) || !line.matchesRevenueCode((Short)HardcodedRevenueCodeSet.ALLOGENEIC.getRevenueCode())) continue;
            found = true;
            break;
        }
        if (!found) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_ALLOGENEIC_TRANSPLANT) || !line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS)) continue;
                claim.assignEdit(EditValue.ALLOGENEIC_TRANSPLANT_REVENUE_CODE_CONFLICT, line);
            }
        }
        return false;
    }
}

