/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapBiosimilarDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiosimilarLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BiosimilarLogic.class);

    BiosimilarLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        short version = claim.getVersionAsPrimitive();
        MapBiosimilarDao dao = processor.getResourceManager().getDataDaoFactory().getMapBiosimilarDao();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_BIOSIMILAR) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || dao.getRow(line, version) != null) continue;
            claim.assignEdit(EditValue.BIOSIMILAR_MODIFIER_MISSING, line);
        }
        return false;
    }
}

